# coding:utf-8
""" 
@version: SmartKit V200R006C00
@time: 2019/06/04 
@file: utils.py 
@function: 
@modify: 
"""

import os
import string

from java.lang import System

def isDevMode():
    return System.getenv('runMode')=='test'

def skipPowerOffCtrl():
    return System.getenv("skipPowerOffCtrl") == 'true'


def skipOfflineCtrl():
    return System.getenv("skipOfflineCtrl") == 'true'


def skipAlarmCheck():
    return System.getenv("skipAlarmCheck") == 'true'

def skipPowerCableCheck():
    return System.getenv("skipPowerCableCheck") == 'true'

def skipDaePoweronCheck():
    return System.getenv("skipDaePoweronCheck") == 'true'


def isEnglishString(strVal):
    if not strVal.strip():
        return True

    if list(filter(lambda ch: not (ch.isspace() or ch.isalnum() or ch in string.punctuation), strVal)):
        return False

    return True


def checkProperties(resPath):
    properties = os.listdir(resPath)
    zhFiles = list(filter(lambda fname: '_zh' in fname, properties))
    enFiles = list(filter(lambda fname: '_en' in fname, properties))
    propertiesPairs = []
    for zhFile in zhFiles:
        enFile = zhFile.replace('_zh', '_en')
        if enFile not in enFiles:
            print('%s not exist' % enFile)
            continue

        propertiesPairs.append((zhFile, enFile))

    for propertiesPair in propertiesPairs:
        zhFile = os.path.join(resPath, propertiesPair[0])
        enFile = os.path.join(resPath, propertiesPair[1])
        checkOneProperty(zhFile, enFile)


def checkOneProperty(zhFile, enFile):
    if not all([zhFile, enFile]):
        print('not all properties files found.')
        return

    zhKSet = set()
    zhDict = dict()
    with open(zhFile, 'r') as zf:
        for line in zf:
            line = line.strip()
            if not line or line.startswith('#') or line.startswith('['):
                continue

            zhK = line.split('=')[0].strip()
            zhV = line.split('=')[1].strip()
            zhKSet.add(zhK)
            zhDict[zhK] = zhV
    notTranslatedKs = set()
    enKSet = set()
    with open(enFile, 'r') as ef:
        for line in ef:
            line = line.strip()
            if not line or line.startswith('#') or line.startswith('['):
                continue

            enK = line.split('=')[0].strip()
            enVal = line.split('=')[1].strip()

            enKSet.add(enK)
            if not enVal:
                notTranslatedKs.add(enK)

            if not isEnglishString(enVal):
                notTranslatedKs.add(enK)

    zhKsNotInEnKs = zhKSet - enKSet
    enKsNotInZhKs = enKSet - zhKSet

    if notTranslatedKs:
        print('*' * 220)
        print('The following keys are not fully translated:')
        print('*' * 220)
        print('\n'.join(notTranslatedKs))

    zhKsNotInEnKsLines = [zhK + ' = ' + zhDict.get(zhK, '') for zhK in zhKsNotInEnKs]
    if zhKsNotInEnKs:
        print('*' * 220)
        print(
            'The following keys are in [{zhFile}] but not in [{enFile}].'
                .format(**{'zhFile': os.path.split(zhFile)[-1], 'enFile': os.path.split(enFile)[-1]}))
        print('*' * 220)
        print('\n'.join(zhKsNotInEnKsLines))

    if enKsNotInZhKs:
        print('*' * 220)
        print(
            'The following keys are in [{enFile}] but not in [{zhFile}].'
                .format(**{'zhFile': os.path.split(zhFile)[-1], 'enFile': os.path.split(enFile)[-1]}))
        print('*' * 220)
        print('\n'.join(enKsNotInZhKs))


if __name__ == '__main__':
    checkProperties(
        r'res/language')
