# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-. All rights reserved.
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil


def is_hypermetro_service(context):
    """判断是否双活业务场景

    :param context:
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    cmd = "show hyper_metro_pair general"

    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag == "NOSUPPORT":
        return False
    if flag is not True:
        raise Exception("execute command [{}] error".format(cmd))

    hyper_metro_pairs = cliUtil.getHorizontalCliRet(cli_ret)

    for hyper_metro_pair in hyper_metro_pairs:
        if hyper_metro_pair.get("Type") == "LUN":
            return True

    return False
