# coding: utf-8
import re

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.rest import restUtil, restData


def getFruGivenTypeAndConditions(context, objType, status=None, location=None):
    """

    :param context:
    :param objType:restData.Enum.ObjEnum FRU枚举类型
    :param location: FRU位置。
    :param status: restData.Enum.RunningStatusEnum FRU状态
    :return:
    """
    currentRunningObj = {}

    locationRegexp = None
    if location:
        locationRe = location + '.*?'
        locationRegexp = re.compile(locationRe)
        BaseFactory.log.info(context, "locationRe=%s" % str(locationRe))

    records = FuncFactory.get_fru_list_info_with_not_support_type(context, objType)
    for linkedPort in records:
        portRunningSta = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.RUNNING_STATUS)
        portLocation = restUtil.Tlv2Rest.getRecordValue(linkedPort, restData.PublicAttributes.LOCATION)
        if location:
            if locationRegexp.search(portLocation) is None:
                continue

        if status and status != portRunningSta:
            continue

        currentRunningObj[portLocation] = restUtil.Tlv2Rest.getStrEn(restData.EnumStr.StrRunningStatusEnum, status)
        BaseFactory.log.info(context, "currentRunningObj location=%s" % str(portLocation))
    return currentRunningObj
