# -*- coding: UTF-8 -*-
"""
专门用于公共数据解析的工具类
纯Python类，不允许使用java接口
"""
DIAGNOSE_END_FLAG = "diagnose>"


def horizontal_parser_for_diagnose(
        ret, key_list, end_flag=DIAGNOSE_END_FLAG, split_key=None):
    """
        专门处理表头不是用空格区分的，而是制表符区分的场景，
        正常按位无法解析的场景。使用python自带的split划分表头和值,
        注意：不能用于处理值中有空值的场景。
        :param ret: 回文
        :param key_list: 需要解析的字段
        :param end_flag: 结束符
        :param split_key: title分隔符
        :return: 字典列表
        """

    try:
        res_dict_list = __horizontal_parser_for_diagnose_impl(
            end_flag, key_list, ret, split_key)
    except Exception:
        return res_dict_list
    return res_dict_list


def __horizontal_parser_for_diagnose_impl(end_flag, key_list, ret, split_key):
    hor_header_dict = {}
    res_dict_list = []
    ret_list = ret.splitlines()
    title_find_flag = False
    for ret in ret_list:
        if not title_find_flag and __check_all_key_in_line(ret, key_list):
            if not split_key:
                head_keys = ret.split()
            else:
                head_keys = list(
                    map(lambda t: t.strip(), ret.split(split_key))
                )
            for key in key_list:
                hor_header_dict[key] = head_keys.index(key)
            title_find_flag = True
            continue

        # 排除 title下面为-- 的空行
        if not ret.replace("-", "").strip():
            continue

        # 解析数据行
        if title_find_flag and not ret.endswith(end_flag):
            res_dict = {}
            values = ret.split()
            if len(values) < len(hor_header_dict):
                continue
            for key in hor_header_dict:
                value_index = hor_header_dict.get(key)
                res_dict[key] = values[value_index]
            res_dict_list.append(res_dict)
    return res_dict_list


def __check_all_key_in_line(line, keys):
    """
    检查是否所有的key都在此行中，如果都在话判定为True
    :param line: 待确认行
    :param keys: 字段
    :return: True 是， False 不是
    """
    for key in keys:
        if key not in line:
            return False
    return True
