# -*- coding: UTF-8 -*-
from cbb.frame.base.regex import Regex

MINI_MODEL_FLAG = "minisystem>"


def get_horizontal_mini_system_ret(mini_ret):
    """
    @summary: 按逐行字典的方式获取水平表格形式的minisystem回显集合
    @param mini_ret: 回显
    @return: 将表格形式回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    """
    try:
        headline = ""
        i = 0
        cliRetList = mini_ret.encode("utf8").splitlines()
        for line in cliRetList:
            match = Regex.search("^\s*-+(\s+-+)*\s*$", line)
            if match:
                headline = match.group(0)
                break
            i += 1

        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        tuple_idxs = Regex.getStartEndList("\s*-+\s*", headline)
        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            # 过滤隔离符号个数大于title情况
            if key:
                keys.append(key.decode("utf8"))

        dictList = []
        for line in field_words:
            if MINI_MODEL_FLAG in line:
                break

            if Regex.find("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            valueList = line.strip().split("  ")
            vals = [value.strip().decode("utf8") for value in valueList if value]

            if len(vals) == len(keys):
                dictList.append(dict(zip(keys, vals)))

        return dictList
    except Exception:
        return []
