# -*- coding: UTF-8 -*-
from cbb.frame.dsl.common import ReturnException


class BaseFaultMode(object):
    def match(self, content):
        raise NotImplementedError


class FindStr(BaseFaultMode):
    def __init__(self, search_key):
        self.search_key = search_key

    def match(self, content):
        return self.search_key in content.lower()


class CmdNoSupport(BaseFaultMode):
    def match(self, content):
        return "^" in content or "command not found" in content.lower()


class NoLicense(BaseFaultMode):
    def match(self, content):
        return "no license" in content.lower


class FindException(BaseFaultMode):
    def __init__(self, code=None):
        self.code = code
        self.type = "exception"

    def match(self, ex):
        if self.code is None:
            # 缺省时，表示捕获所有异常
            return True
        if hasattr(ex, "get_code"):
            return ex.get_code() == self.code
        return False


class ReturnIfHandler:
    def __init__(self, return_setting):
        self.setting = return_setting

    def process(self, origin_ret):
        if not self.setting:
            return origin_ret
        for mode in self.setting:
            if isinstance(mode, FindException):
                continue
            if isinstance(mode, BaseFaultMode):
                mode_obj = mode
            else:
                mode_obj = mode()
            if isinstance(mode_obj, FindException):
                continue
            if mode_obj.match(origin_ret):
                raise ReturnException(self.setting.get(mode))
        return origin_ret

    def process_exception(self, ex):
        if not self.setting:
            raise ex
        for mode in self.setting:
            if isinstance(mode, BaseFaultMode):
                mode_obj = mode
            else:
                mode_obj = mode()
            if not isinstance(mode_obj, FindException):
                continue
            if mode_obj.match(ex):
                return self.setting.get(mode)
        raise ex
