﻿# -*- coding: UTF-8 -*-
from com.huawei.ism.exception import IsmException  # @UnresolvedImport


class SftpConnection(object):
    RE_CONNECTION_TIMES = 3
    SFTP_DEFUAL_PORT = 22
    SFTP_CAN_NOT_CONNECT_CODE = "1073949187"
    _instance = None
    _sftp = None
    _connectorFactory = None
    _ip = None
    _port = None

    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(SftpConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance

    def __init__(self, connectorFactory, ip, port=SFTP_DEFUAL_PORT):
        self._connectorFactory = connectorFactory
        self._ip = ip
        self._port = port

    def upload(self, remoteFilePath, localDirPath, ip=None):
        conn = self._sftp
        if None == conn:
            return False
        try:
            conn.putFile(remoteFilePath, localDirPath, ip)
            return True
        except IsmException:
            raise Exception(self.SFTP_CAN_NOT_CONNECT_CODE, "")

    def download(self, remoteFilePath, localDirPath, ip=None):
        conn = self._sftp
        if None == conn:
            return False
        try:
            conn.getFile(localDirPath, remoteFilePath, ip)
            return True
        except IsmException:
            raise Exception(self.SFTP_CAN_NOT_CONNECT_CODE, "")

    def create(self, dev):
        reConnectionTimes = 0
        while self._sftp is None and reConnectionTimes < SftpConnection.RE_CONNECTION_TIMES:
            try:
                self._sftp = self._connectorFactory.createSftpConnector(dev)
            except IsmException:
                self._sftp = None
            reConnectionTimes += 1
        return self._sftp

    def getSftp(self, dev):
        if self._sftp is None:
            self.create(dev)

        if self._sftp is None:
            raise Exception(self.SFTP_CAN_NOT_CONNECT_CODE, "")

        return self._sftp
