#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

"""
@time: 2021/04/29
@file: file_operate_util.py
@function: 压缩操作util， 封装了java的接口，便于单元测试mock
"""
import os
import zipfile


def compress_zip(source_dir_path, out_full_name):
    """
    压缩指定文件夹
    1、结果不会包含原目录，是把原目录下所有文件直接打成out_full_name
    2、压缩过程中可能会出现error
    :param source_dir_path: 目标文件夹路径
    :param out_full_name: 压缩文件保存路径+xxxx.zip
    """
    with zipfile.ZipFile(out_full_name, "w", zipfile.ZIP_DEFLATED) as zip_file:
        for path, dir_names, file_names in os.walk(source_dir_path):
            # 去掉目标跟路径，只对目标文件夹下边的文件及文件夹进行压缩
            file_path = path.replace(source_dir_path, '')
            for file_name in file_names:
                zip_file.write(os.path.join(path, file_name),
                               os.path.join(file_path, file_name))


def decompress_zip(origin_file_path, destination_dir):
    """
    解压zip包
    :param origin_file_path: 原始文件路径
    :param destination_dir: 解压目的路径
    """
    from com.huawei.ism.tool.obase.utils import FileAssistant
    FileAssistant.deCopmressZipUnLimited(destination_dir, origin_file_path)


def decompress_tgz(source_file_path, destination_dir):
    """
    解压tgz
    :param source_file_path:  原始文件路径
    :param destination_dir: 目标目录
    """
    from com.huawei.ism.tool.obase.utils import FileAssistant
    FileAssistant.deCompressTgz(destination_dir, source_file_path)


def clean_dir(target_dir):
    """
    清零某个目录，会清掉目录本身
    :param target_dir: 目标目录
    """
    from com.huawei.ism.tool.obase.utils import FileAssistant
    FileAssistant.delDirAndFile(target_dir)


def make_dir(target_dir):
    """
    创建目录
    :param target_dir: 目标目录
    """
    if not os.path.exists(target_dir):
        os.mkdir(target_dir)


def get_safe_path(path):
    """
    获取安全路径
    :param path: 路径
    :return: 校验后的路径 str
    """
    from com.huawei.ism.tool.base.utils import FilePathUtils
    return FilePathUtils.getSafePath(path)
