#!bin/bash

# 1、先做版本判断，如果是合入补丁的版本，就无需巡检
# 2、判断当前软raid是否处在clean状态，clean则通过，非clean则失败，检测命令 sudo mdadm --detail  /dev/md200  | grep clean
# 3、使用mount确认检查文件系统是否只读，如果文件系统只读则巡检不通过。
# 4、执行show dha singlemodelconfig vendor=seagate disk_type=sas model_type=medium获取当前状态，根据当前状态来执行change dha singlemodelconfig 命令来触发写CCDB，完成检测，如果写CCDB失败则巡检不通过。注：确保配置不变
# 5、检测文件系统的状态 tune2fs -l /dev/md200，若非clean则巡检不通过。
# 合入版本：融合ARM版本（V5R7C60SPC100-V5R7C73SPC100所有型号）

path_file_path=/OSM/conf/patch.yml

G_RET_NO_NEED_CHECK=0
G_RET_NEED_CHECK=1
G_CMD_EXEC_SUCCESS=0
G_CMD_EXEC_FAIL=1
G_RAID_IS_EXIST=0
G_RAID_IS_NOT_EXIST=1
G_RAID_IS_NORMAL=0
G_RAID_IS_NOT_NORMAL=1

#判断补丁版本
function CheckLessThanMaxPatchVersion()
{
    local patchMaxVer=$1
    if [ ! -f $path_file_path ] ;then # 补丁配置文件不存在，说明为基线版本，需要进行检查
        return ${G_RET_NEED_CHECK}
    fi

    local curPatchVer=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $curPatchVer ] ;then	# 未获取到版本号，说明环境有问题，进行检查
        return ${G_RET_NEED_CHECK}
    fi
    if [ `expr substr $curPatchVer 4 5 \< substr $patchMaxVer 4 5` -eq 1 ] ;then
        return ${G_RET_NEED_CHECK}
    fi
}

function IsNeedCheck()
{
    local manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
    curBaseVer=`cat ${manifest_file_path} | grep Version | head -1 | awk '{print $(NF)}'`
    OS_echo "CheckCcdbFilesystem.sh: CurBaseVer: ($curBaseVer). [CheckCcdbFilesystem]" >/dev/null
    if [ x"${curBaseVer}" == x"6200819073" ] ;then  # V5R7C73SPC100
        CheckLessThanMaxPatchVersion SPH120
        if [ "$?" == ${G_RET_NEED_CHECK} ] ;then
            return ${G_RET_NEED_CHECK}
        fi
        return ${G_RET_NO_NEED_CHECK}
    elif [ x"${curBaseVer}" == x"6200815132" ] ;then # V5R7C71SPC100
        CheckLessThanMaxPatchVersion SPH150
        if [ "$?" == ${G_RET_NEED_CHECK} ] ;then
            return ${G_RET_NEED_CHECK}
        fi
        return ${G_RET_NO_NEED_CHECK}
    else
        return ${G_RET_NEED_CHECK}
    fi
}

# 触发写CCDB
function WriteCcdbCheck()
{   
    #获取Super_admin用户列表
	super_admin_list=$(echo -e "aa showalluser\nexit\n" |diagnose  --auto | grep "Super_admin" | awk '{print $1}' 2>&1)
	if [[ "$super_admin_list" = "" ]] ; then
		super_admin_list=admin
	fi
	#获取第一个Super_admin用户
	for admin_user in $super_admin_list
	do
	if [[ "$admin_user" != "" ]] ; then
		break;
	fi
	done
    #查询dha singlemodelconfig配置
	total_count_switch=$(/ISM/cli/ismcli -u $admin_user -c "change user_mode current_mode user_mode=developer;show dha singlemodelconfig vendor=seagate disk_type=sas model_type=medium" |grep "Total Count Switch" |awk -F ':' '{print $2}' |awk -F ' ' '{print $1}' 2>&1)
	if [ -z "$total_count_switch" ]; then
        return ${G_CMD_EXEC_SUCCESS}
    elif [ "$total_count_switch" != "On" ] && [ "$total_count_switch" != "Off" ]; then
        return ${G_CMD_EXEC_SUCCESS}
	fi
    local tryTimes=0
    while (true); 
    do
    { 
        sourceRes=$(/ISM/cli/ismcli -u $admin_user -c "change user_mode current_mode user_mode=developer;change dha singlemodelconfig vendor=seagate disk_type=sas model_type=medium total_count_switch=${total_count_switch}" 2>&1)
        checkRes=$(echo -e "$sourceRes" |grep -o "Command executed successfully." 2>&1)
        if [ x"${checkRes}" == x"Command executed successfully." ] ;then
            return ${G_CMD_EXEC_SUCCESS}
        fi
        if [ $tryTimes -ge 1 ]; then
            break
        fi
        let tryTimes+=1
        sleep 10
    }; 
    done
    OS_echo "CheckCcdbFilesystem.sh: WriteCcdbCheck: sourceRes=($sourceRes). [CheckCcdbFilesystem]" >/dev/null
    return ${G_CMD_EXEC_FAIL}

}

function checkRaidIsExist()
{
    md="/dev/md200"
    local tryTimes=0;
    while (true); 
    do
    { 
        if [ -e "$md" ]; then
            return ${G_RAID_IS_EXIST}
        fi
        if [ $tryTimes -ge 3 ]; then
            break
        fi
        let tryTimes+=1
        sleep 10
    }; 
    done
    OS_echo "CheckCcdbFilesystem.sh: checkRaidIsExist: ccdb raid is not exist. [CheckCcdbFilesystem]" >/dev/null
    return ${G_RAID_IS_NOT_EXIST}
}

function checkRaidIsNormal()
{
    local tryTimes=0;
    while (true); 
    do
    { 
        checkRes=$(sudo mdadm --detail /dev/md200 | grep State |grep clean 2>&1)
        if [ ! -z "$checkRes" ]; then
            return ${G_RAID_IS_NORMAL}
        fi
        if [ $tryTimes -ge 3 ]; then
            break
        fi
        let tryTimes+=1
        sleep 10
    }; 
    done
    tempRes=$(sudo mdadm --detail /dev/md200 2>&1)
    OS_echo "CheckCcdbFilesystem.sh: checkRaidIsNormal: ccdb raid is not clean, info=($tempRes). [CheckCcdbFilesystem]" >/dev/null
    return ${G_RAID_IS_NOT_NORMAL}
}

function checkCcdbFileSystemStatus()
{
    IsNeedCheck
    if [ "$?" == ${G_RET_NO_NEED_CHECK} ] ;then
        echo "True"
        echo ""
        exit 0
    fi

    # 判断当前软raid是否处在降级状态
    checkRaidIsExist
    if [ "$?" == ${G_RAID_IS_NOT_EXIST} ] ;then
        echo "false"
        echo "10009"
        exit 0
    fi
    checkRaidIsNormal
    if [ "$?" == ${G_RAID_IS_NOT_NORMAL} ] ;then
        echo "false"
        echo "10009"
        exit 0
    fi

    # 使用mount确认检查文件系统是否只读
    checkRes=$(cat /proc/mounts |grep "md200" |grep "rw" 2>&1)
    if [ -z "$checkRes" ]; then
        echo "false"
        echo "10012"
        exit 0
    fi
    # 触发写CCDB检查
    WriteCcdbCheck
    if [ "$?" == ${G_CMD_EXEC_FAIL} ] ;then
        echo "false"
        echo "10010"
        exit 0
    fi

    # 检测文件系统的状态
    checkRes=$(tune2fs -l /dev/md200 |grep "Filesystem state" |grep -E 'not clean|with errors' 2>&1)
    if [ ! -z "$checkRes" ]; then
        tempRes=$(tune2fs -l /dev/md200)
        OS_echo "CheckCcdbFilesystem.sh: checkFilesystemState: filesystem state is not clean or with errors, info=($tempRes). [CheckCcdbFilesystem]" >/dev/null
        echo "false"
        echo "10011"
        exit 0
    fi
}

checkCcdbFileSystemStatus
echo "True"
echo ""
exit 0
