#!/bin/bash
#ͷű
source /OSM/script/os_load_base.sh

UPGRADE_SH=check_frame.sh
G_DISK_UTIL=/tmp/diskusagenew

OS_ExecDiagnose()
{
    L_CMD=$1
    L_FILE=$2

    if [ "$L_FILE" == "" ]; then
diagnose_usr --auto <<EOF
attach 12
$L_CMD
quit
EOF
    else
diagnose_usr --auto <<EOF > "$L_FILE"
attach 12
$L_CMD
quit
EOF
    fi
    return 0
}

GetCPUUsage_QOS()
{
    L_CMD="qos show cur_cpu_load"
    OS_ExecDiagnose "$L_CMD"
}

# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_FREE_MEM_ENOUGH()
{    
    OS_echo "[$UPGRADE_SH]: begin to check the free mem when upgrade check."
    #dhaУҪֹͣdha, ˽űBDMά˴ֻãĽ
    if [ -f /OSM/script/bdm_stop_dha_aimodel.sh ]
    then
        chmod +x /OSM/script/bdm_stop_dha_aimodel.sh &> /dev/null
        /OSM/script/bdm_stop_dha_aimodel.sh &> /dev/null
    fi

    sleep 1

    #check memory is enough
    echo 3 >/proc/sys/vm/drop_caches

    FREE_MEM=`free -m|grep ^Mem|awk '{print $4}'`
    echo "$FREE_MEM"
    return 0
}
# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_CPU_USAGE()
{    
    OS_echo "[$UPGRADE_SH]: begin to check the cpu using when upgrade check."
    #dhaУҪֹͣdha, ˽űBDMά˴ֻãĽ
    if [ -f /OSM/script/bdm_stop_dha_aimodel.sh ]
    then
        chmod +x /OSM/script/bdm_stop_dha_aimodel.sh  &> /dev/null
        /OSM/script/bdm_stop_dha_aimodel.sh  &> /dev/null
    fi

    sleep 10

    #QOSdiagnoseCPU
    local var=0
    for((i=0;i<10;i++))
    do
        CPU_USAGE=`GetCPUUsage_QOS`
        tmpvar=`echo "$CPU_USAGE" |grep "CPU load average" |awk '{print $4}'`
        var=$((var + tmpvar))
        sleep 1
    done
    L_CUR_CPU_USING=$((var / 10 ))

    echo "$L_CUR_CPU_USING"
    return 0
}

# **************************************************************************** #
# Function Name: OS_CheckDiskUsage
# Description: check if the disk usage is more than threshold
# Parameter:
# Return:
# **************************************************************************** #
GetDiskUsage()
{
    L_CMD="sddebug userate 60"
    OS_ExecDiagnose "$L_CMD"
}

OS_CheckDiskUsage()
{
    local -i L_OneDiskUsage=0
    local -i L_DiskUtilUsageResult=0
    local -i L_DiskCount=0
    local -i L_DiskAverage=0
    local -i L_DiskSum=0
    local -i L_DiskUsageIgnore=10
    
    [ -f $G_DISK_UTIL ] && rm $G_DISK_UTIL
    GetDiskUsage > $G_DISK_UTIL
    while read sdid util type; 
    do
        if [ -n "$(echo $sdid | grep '[a-zA-Z]')" -o -z "$sdid" ]; then
            OS_echo "${UPGRADE_SH}: sdid=$sdid"
            continue;
        fi
        L_OneDiskUsage=$util
        OS_echo "${UPGRADE_SH}: sdid=$sdid  util=${L_OneDiskUsage}"
        #Сڵ10ųƽֵֵԱⳤΪߺܵ͵̶ƽֵӰ
        if [ ${L_DiskUsageIgnore} -gt ${L_OneDiskUsage} ]; then
            OS_echo "${UPGRADE_SH}: sdid=$sdid diskusage less than 10, continue"
            continue;
        fi
        [ ${L_OneDiskUsage} -gt ${L_DiskUtilUsageResult} ] && L_DiskUtilUsageResult=${L_OneDiskUsage}
        L_DiskCount=$(( L_DiskCount + 1 ))
        L_DiskSum=$((L_DiskSum + L_OneDiskUsage ))
    done < $G_DISK_UTIL &>/dev/null
    
    #ȡĴΪ0ʱ򣬼ƽ
    if [ 0 -ne $L_DiskCount ]; then
        L_DiskAverage=$(( L_DiskSum / L_DiskCount ))
    fi
    if [ ${L_DiskUtilUsageResult} -gt 80 -o ${L_DiskAverage} -gt 60 ]; then
        echo "False"
    else
        echo "True"
    fi

    return 0
}
# **************************************************************************** #
# Function Name: CHECK_BEFORE_INSTALL_HOTPATCH
# Description: Ȳǰ
# Parameter:
# Return:
# **************************************************************************** #
CHECK_BEFORE_INSTALL_HOTPATCH()
{
    OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH">/dev/null
    
    local L_UPG_HOTPATCH_PATH_NAME=$1
    /OSM/script/os_upgrade_hotpatch.sh -g $L_UPG_HOTPATCH_PATH_NAME &>/dev/null
    L_IsSpecPatch=$? 
    
    #жǷⲹ
    if [ 10 -eq ${L_IsSpecPatch} ];then
        #ⲹҪǰļ
        echo "True"
        echo "pass"
        return 0
    fi
    
    #Ȳǰļ
    /OSM/script/os_upgrade_hotpatch.sh -w install $L_UPG_HOTPATCH_PATH_NAME &>/dev/null
    L_RET=$? 
    
    if [ 0 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 0">/dev/null
        echo "True"
        echo "pass"
        return 0
    fi
    
    if [ 1 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 1">/dev/null
        echo "False"  
        echo "pkgerror"
        return 0
    fi
    
    if [ 2 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 2">/dev/null
        echo "False"  
        echo "versionerror"
        return 0
    fi
    
    if [ 3 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 3">/dev/null
        echo "False"  
        echo "reinstall"
        return 0
    fi
    
    if [ 4 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 4">/dev/null
        echo "False"  
        echo "memoryerror"
        return 0
    fi
    
    if [ 5 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 5">/dev/null
        echo "False"  
        echo "sysdiskerror"
        return 0
    fi
    
    if [ 6 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 6">/dev/null
        echo "False"  
        echo "sysbusy"
        return 0
    fi
    
    if [ 8 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 8">/dev/null
        echo "False"  
        echo "hotpatcherror"
        return 0
    fi
       
    echo "False"  
    echo "failed"  
    return 0
   
}

OS_CheckPartitionSpace()
{
    image_partition=`df /startup_disk/image 2>/dev/null | grep "startup_disk/image" | awk '{print $5}' | awk -F '%' '{print $1}'`
    coffer_partition=`df -m /OSM/coffer_data 2>/dev/null | grep "OSM/coffer_data" | awk '{print $4}' | awk -F '.' '{print $1}'`
    # coffer partition free space should be more than 1572864 bytes(1.5G)
    local sys_update_size=0
    if [[ -f /OSM/coffer_data/update/SYS_software.tgz ]]; then
        sys_update_size=`du -s -m /OSM/coffer_data/update/SYS_software.tgz | awk '{print $1}'`
    fi
    coffer_partition=`expr ${coffer_partition} + ${sys_update_size}`

    local cur_version=`readlink /startup_disk/image/pkg_cur | awk -F '/' '{print $1}'`
    local versions=`ls /startup_disk/image/ | grep -E "^[0-9]{10}$" | grep -v ${cur_version}`
    local image_other_size=0
    for ver in ${versions}
    do
        image_other_size=$(( $image_other_size + `du -m -s /startup_disk/image/${ver} | awk '{print $1}'` ))
    done
    local total_image_size=`df -m /startup_disk/image 2>/dev/null | grep "startup_disk/image" | awk '{print $2}'`
    image_partition=`expr ${image_partition} - ${image_other_size} \* 100 / ${total_image_size}`

    if [ ${image_partition} -gt 50 -o ${coffer_partition} -lt 1536 ];then
        OS_echo "[$UPGRADE_SH]: image partition used ${image_partition}%, coffer_data available space is ${coffer_partition}M">/dev/null
        coffer_partition_h=`df -h 2>/dev/null | grep "OSM/coffer_data" | awk '{print $4}'`
        echo "False"
        echo "10007"
        echo ${image_partition}"%;50%;"${coffer_partition_h}";1.5G"
        return 0
    fi
    echo "True"
    echo ""
    echo ""
    return 0
}

# --------------------------  main  ------------------------------------------ #

#Ϊ˵OS_SET_DISK_RW

L_INPUT_PARA_NUM=$#

if [ $L_INPUT_PARA_NUM -lt 1 ] ; then
    OS_echo "${UPGRADE_SH}: [check_frame.sh]wrong input num: $#." >/dev/null
else
    L_TMP=`echo $1 | grep '\-[a-zA-Z0-9]'`
    if [ -z "$L_TMP" ] ; then
        OS_echo "${UPGRADE_SH}: [check_frame.sh]wrong input para $1." >/dev/null
    fi
fi

while getopts cmdkh: options 2>/dev/null
do
    case $options in
        c)  OS_echo "${UPGRADE_SH} [-c]: Upgrade get cpu usage" >/dev/null
            OS_CHECK_CPU_USAGE
            exit $?
            ;;
        m)  OS_echo "${UPGRADE_SH} [-m]: Upgrade get free mem" >/dev/null
            OS_CHECK_FREE_MEM_ENOUGH
            exit $?
            ;;
        d)  OS_echo "${UPGRADE_SH} [-d]: Upgrade check disk usage" >/dev/null
            OS_CheckDiskUsage
            exit $?
            ;;
        k)  OS_echo "${UPGRADE_SH} [-k]: Check whether the available space of the system disk image and data partition is sufficient." >/dev/null
            OS_CheckPartitionSpace
            exit $?
            ;;
        h)  OS_echo "${UPGRADE_SH} [-h]: Upgrade check hotpatch" >/dev/null
            CHECK_BEFORE_INSTALL_HOTPATCH $OPTARG
            exit $?
            ;;
        *) OS_echo "${UPGRADE_SH}: invalid options" >/dev/null
            exit 1
            ;;
    esac
done

exit 1

