#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import subprocess
import sys
import re
import tempfile
import time

# 定义返回值
RETURN_OK = 0
RETURN_ERROR = 1
RETURN_RETRY = 2
RETURN_RETRY_FAILED = 3

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')
CURRENT_DIR = os.path.dirname(os.path.realpath(__file__))

def get_soft_version(cmd_result):
    result = re.findall(r"Software\sVersion([\s\S]*?)HotPatch\sVersion", cmd_result)
    if not result:
        return None
        
    lines = result[0].strip().splitlines()
    if len(lines) > 2: # 如果有控制器版本，回显行数大于2
        return re.findall(r"[^\s]+", lines[-1].strip())[3] # 当前版本在分割数组中第3个位置
    return None


def get_patch_version(cmd_result):
    result = re.findall(r"HotPatch\sVersion([\s\S]*)", cmd_result)
    if not result:
        return None
        
    lines = result[0].strip().splitlines()
    if len(lines) > 2:  # 如果有补丁，回显行数大于2
        return re.findall(r"[^\s]+", lines[-1].strip())[3] # 补丁版本在分割数组中第3个位置
    return None


def check_cur_vision():
    cmd = ["/ISM/cli/ismcli", "-u", "admin", "-c", "show upgrade package"] 
    
    process = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, close_fds=True);
    stdout, _ = process.communicate()
    cmd_results = stdout.decode("utf-8").strip()
    if not cmd_results:
        return False
    
    soft_ver = get_soft_version(cmd_results)
    if not soft_ver:
        logging.warning("get Software Version failed.")
        return False
    
    if soft_ver != "V500R007C60SPC100" and soft_ver != "V500R007C60SPC300":
        return True
    
    patch_ver = get_patch_version(cmd_results)
    if not patch_ver:
        logging.warning("get HotPatch Version failed.")
        return False
    
    if (soft_ver == "V500R007C60SPC100" and patch_ver >= "V500R007C60SPH101") or \
        (soft_ver == "V500R007C60SPC300" and patch_ver >= "V500R007C60SPH302"):
        return True
    return False


# 执行命令并把内容输出到文件
def exc_cmd(cmdStr, filePath):
    cmdStr = cmdStr + filePath
    ret = os.system(cmdStr)
    if ret:
        logging.warning("CHECK_NFS_LOCK_CNT: Cmd(%s) exec failed, ret %d.", cmdStr, ret)
    return ret


def is_exist_lif(linesArray):
    slock_str_start = 'Show port begin'

    for line in linesArray:
        if slock_str_start in line:
            logging.warning("CHECK_NFS_LOCK_CNT: The lif is exist.")
            return True

    return False


def check_lif_count_process(diagnose_cmd, temp_file):
    if exc_cmd(diagnose_cmd, temp_file) != RETURN_OK:
        return RETURN_RETRY

    with open(temp_file) as lines:
        linesArray = lines.readlines()
        if is_exist_lif(linesArray) is True:
            return RETURN_ERROR
        else:
            return RETURN_OK


def get_board_type():
    cmd = "cat /proc/osp/bsp |grep 'Product Name' |awk '{print $4}'"
    return str(subprocess.check_output(cmd, shell=True).decode().strip('\n'))


def check_lif_count():
    mem_cut = get_board_type() in ('PANGEA_V6R3C30_HI1620S_1P_2U2C_SAS', 'PANGEA_V6R3C30_HI1620S_1P1L_2U2C_SAS',
                                   'PANGEA_V6R3C30_HI1620S_1P1H_2U2C_SAS')
    diagnose_cmd = "echo -e 'attach %d \neam showtypeport 9\nexit\n' | diagnose_usr --auto > " % (12 if mem_cut else 21)
    
    is_not_check = check_cur_vision()
    if is_not_check:
        return RETURN_OK
    
    _fd, temp_file = tempfile.mkstemp(prefix="DEVM_", text=True)
    os.close(_fd)

    for index in range(4):
        check_result = check_lif_count_process(diagnose_cmd, temp_file)
        if check_result == RETURN_RETRY:
            # 睡眠几秒钟再重试
            time.sleep((index + 1) * 3)
        else:
            os.remove(temp_file)
            return check_result

    # 重试3次都失败，则直接返回失败，不再进行锁检查
    os.remove(temp_file)
    return RETURN_RETRY_FAILED


def check_nfs_lock_process(linesArray):
    checkResult = RETURN_ERROR
    for line in linesArray:
        if "s_lock:" in line:
            tempStr = line.replace(' ', '')  # 把空格去掉
            nfsLockCnt = int(tempStr.split(':')[1])
            if nfsLockCnt != 0:
                logging.warning("CHECK_NFS_LOCK_CNT: The nfs lock is (%u).", nfsLockCnt)
                checkResult = RETURN_ERROR
            else:
                checkResult = RETURN_OK
            break
    return checkResult


def check_nfs_lock():
    check_result = RETURN_ERROR
    storageCmd = "nas_proto_pum -m nlm -c get_stats > "

    _fd, temp_file = tempfile.mkstemp(prefix="DEVM_", text=True)
    os.close(_fd)

    if exc_cmd(storageCmd, temp_file) != RETURN_OK:
        os.remove(temp_file)
        return RETURN_ERROR

    with open(temp_file) as lines:
        linesArray = lines.readlines()
        check_result = check_nfs_lock_process(linesArray)

    os.remove(temp_file)
    return check_result


def main():
    try:
        check_result = check_lif_count()
        if check_result == RETURN_OK:
            print("True")
        elif check_result == RETURN_RETRY_FAILED:
            print("False")
        else:
            check_result = check_nfs_lock()
            if check_result == RETURN_OK:
                print("True")
            else:
                print("False")

        return RETURN_OK

    except Exception as e:
        logging.exception("CHECK_NFS_LOCK_CNT: %s", e)
        print("False")
        return RETURN_ERROR


if __name__ == '__main__':
    sys.exit(main())
