#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2022. All rights reserved.
import os
import sys
import time
import yaml

from check_item.check_util import shell
from infra.debug.log import swm_logger as log

PYTHON_2 = '2.7' in sys.version


def decode_str(value):
    if not PYTHON_2 and isinstance(value, bytes):
        return value.decode()
    return value


def check_mem_is_enough(max_memory):
    shell.call_system_cmd("echo 3 >/proc/sys/vm/drop_caches")
    # 重试查询，防止出现一次为空无法查询到内存
    for _ in range(3):
        ret, out = shell.call_system_cmd("free -m|grep ^Mem|awk '{print $4}'")
        log.info('CHECK_UTIL: Mem info is %s', out)
        out = out.strip()
        if ret or not out or not out.isdigit():
            time.sleep(1)
            continue
        if int(out) >= max_memory:
            return True
        return False
    return False


def get_pkg_version(manifest_file):
    """

    :param manifest_file:
    :return:
    """
    if not os.path.exists(manifest_file):
        log.warning("Can not get the new version, config %s not existing.", manifest_file)
        return ""

    with os.fdopen(os.open(manifest_file, os.O_RDONLY, 0o640), 'r') as fd:
        cfg_yml = yaml.safe_load(fd)
        try:
            target_version = str(cfg_yml.get("SYS")["Version"])
            log.info('Get Version(%s).', target_version)
            return target_version
        except Exception as e:
            log.error("Failed to get version(%s).", str(e))
            return ""


def get_patch_version(manifest_file):
    """

    :param manifest_file:
    :return:
    """
    if not os.path.exists(manifest_file):
        log.warning("Can not get the new version, config %s not existing.", manifest_file)
        return ""

    try:
        with os.fdopen(os.open(manifest_file, os.O_RDONLY, 0o640), 'r') as fd:
            cfg_yml = yaml.safe_load(fd)
        patch_version = str(cfg_yml.get("PatchConf")["patch_version"])
        return patch_version
    except Exception:
        log.exception("Failed to get version.")
    return ""


def exec_diagnose(cmd, retry_times=3):
    command = "diagnose --auto <<EOF\n{cmd:s}\nquit\nEOF".format(cmd=cmd)
    output, ret_code = [], 1
    while retry_times > 0:
        ret_code, output = shell.call_system_cmd(command)
        if ret_code:
            retry_times -= 1
            time.sleep(1)
        else:
            break

    return ret_code, output
