#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import time
import sys


logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


def swm_check_time():
    """
    检查10分钟之内的
    :return:
    """
    file = "/OSM/coffer_log/log/alarm/alarmrecord.dat"
    almid = 1103551332454
    end_time = time.time()
    begin_time = int(end_time - 600)
    cmd = "sqlite3 {0} '.timeout 10000' 'select * from tbl_almrecord where i_almid={1} and i_almtype=0 and" \
          " i_almoccurtime>{2} and i_almoccurtime<{3}'".format(file, almid, begin_time, end_time)
    if os.popen(cmd).read():
        logging.info("swm: It is poweron in 10 minutes.")
        print("True")
        return 0

    print("False")
    return 0


def main():
    try:
        ret = swm_check_time()
        return ret
    except Exception as e:
        logging.exception("swm: %s", e)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
