#!/bin/bash
# ********************************************** ***************************** #
# File Name: fdsa_tunefs_inspection.sh
# Description: fdsa日常巡检
# Input: none        
# Output: none
# Created: 2024-09-13
# Function List：
# History
# **************************************************************************** #

source /OSM/script/os_load_base.sh

manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
path_file_path=/OSM/conf/patch.yml
SYSDISK_SWITCH=/OSM/coffer_log/log/heal/data/fdsa_sysdisk_switch

#目录检测列表：
CHECK_DIRECTORIES[0]="/startup_disk/conf/"
CHECK_DIRECTORIES[1]="/OSM/coffer_data/"
CHECK_DIRECTORIES[2]="/OSM/coffer_log/"
CHECK_DIRECTORIES[3]="/OSM/coffer_bin/"
CHECK_DIRECTORIES[4]="/OSM/coffer_runningdata/"

FAULT_COUNT=0
PATCH_VERSION="SPH0" # 默认为基线版本

check_file_system_state()
{
	i=0
	while [ $i -lt ${#CHECK_DIRECTORIES[*]} ]
	do
        if [ -d ${CHECK_DIRECTORIES[$i]} ];then
            mount_dir=$(echo ${CHECK_DIRECTORIES[$i]} | sed 's/\/*$//')

            device_list=$(cat /proc/mounts | grep ${mount_dir} | awk '{print $1}')
		    if [ ! -n "$device_list" ]; then
			    let i++
			    continue
		    fi

		    for dev_name in $device_list; do
			    fs_state=`sudo tune2fs -l ${dev_name} | grep 'Filesystem state' | awk -F: '{print $2}' | sed 's/^[\t ]*//g'`
			    if [ "${fs_state}" != "" ] && [ "${fs_state}" != "clean" ]; then
				    OS_echo "[fdsa_check_sysdisk.sh]SYS_RAID:${mount_dir} filesystem state error."
				    let FAULT_COUNT++
			    fi
		    done
        fi
		let i++
	done

	return 0
}

if [ ! -f $manifest_file_path ]; then	# manifest文件不存在
    OS_echo "The manifest.yml path or file does not exist"
    echo "True"
    exit 0
fi
MainVer=`cat ${manifest_file_path}  | grep -w SpcVersion | awk '{print $(NF)}'`

if [ -f $path_file_path ]; then
    try_get_patchver=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $try_get_patchver ]; then
        OS_echo "Cannot get patch version, check environment pls."
        echo "True"
        exit 0
    fi
    PATCH_VERSION=$try_get_patchver
fi

if [ "$MainVer" == "V500R007C71SPC100" ]; then
    if [ `expr substr $PATCH_VERSION 4 4 \< substr "SPH150" 4 4` -eq 1 ]; then
        echo "True"
        exit 0
    fi

    if [ -f ${SYSDISK_SWITCH} ]; then
        OS_echo "${SYSDISK_SWITCH} exists, inspection passed."
        echo "True"
        exit 0
    fi
fi

if [ "$MainVer" == "V500R007C73SPC100" ]; then
    if [ `expr substr $PATCH_VERSION 4 4 \< substr "SPH120" 4 4` -eq 1 ]; then
        echo "True"
        exit 0
    fi

    tmp_result=`echo -e "fdsa sysdiskmode show" | diagnose --auto | grep "sysdisk mode is" | grep -o '[0-9]\+'`
    if [ ${tmp_result} == 3 ]; then
        OS_echo "sysdisk mode is 3, inspection passed."
        echo "True"
        exit 0
    fi
fi

check_file_system_state

if [ 0 -ne $FAULT_COUNT ]; then
	OS_echo "Check file system state not clean, inspection failed."
    echo "False"
	exit 0
fi

echo "True"
exit 0