#!/bin/bash
# ********************************************** ***************************** #
# File Name: fdsa_tunefs_pre_evaluate.sh
# Description: 检测系统分区文件系统是否异常
# Input: none        
# Output: none
# Created: 2024-09-15
# Function List：
# History
# **************************************************************************** #

source /OSM/script/os_load_base.sh

#目录检测列表：
CHECK_DIRECTORIES[0]="/startup_disk/conf/"
CHECK_DIRECTORIES[1]="/OSM/coffer_data/"
CHECK_DIRECTORIES[2]="/OSM/coffer_log/"
CHECK_DIRECTORIES[3]="/OSM/coffer_bin/"
CHECK_DIRECTORIES[4]="/OSM/coffer_runningdata/"

FAULT_COUNT=0

check_file_system_state()
{
	i=0
	while [ $i -lt ${#CHECK_DIRECTORIES[*]} ]
	do
        if [ -d ${CHECK_DIRECTORIES[$i]} ];then
            mount_dir=$(echo ${CHECK_DIRECTORIES[$i]} | sed 's/\/*$//')

            device_list=$(cat /proc/mounts | grep ${mount_dir} | awk '{print $1}')
		    if [ ! -n "$device_list" ]; then
			    let i++
			    continue
		    fi

		    for dev_name in $device_list; do
			    fs_state=`sudo tune2fs -l ${dev_name} | grep 'Filesystem state' | awk -F: '{print $2}' | sed 's/^[\t ]*//g'`
			    if [ "${fs_state}" != "" ] && [ "${fs_state}" != "clean" ]; then
				    OS_echo "[fdsa_check_sysdisk.sh]SYS_RAID:${mount_dir} filesystem state error."
				    let FAULT_COUNT++
			    fi
		    done
        fi
		let i++
	done

	return 0
}

check_file_system_state

if [ 0 -ne $FAULT_COUNT ]; then
	OS_echo "[fdsa_check_sysdisk.sh]Sysdisk check is error."
    echo "False"
	exit 0
fi

echo "True"
exit 0