#!/usr/bin/python
# coding=utf-8

import subprocess
import re
import argparse

class Preupgrade_check:
    """
    
    """

    def __init__(self, mode):
        self.notify = 'bsp getbiosflashstatus %d' % mode

    def diagnose(self, command):
        cmd = 'diagsh --attach="*_21" --cmd="%s" | grep -v "diagsh>"' % command
        fd = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
        stdout = fd.communicate()
        cmd_info = stdout[0].decode("utf-8").split('\n')
        if re.search("fail", cmd_info[1], re.IGNORECASE):
            cmd = 'diagsh --attach="*_12" --cmd="%s" | grep -v "diagsh>"' % command
            fd = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
            stdout = fd.communicate()
            cmd_info = stdout[0].decode("utf-8").split('\n')
        return cmd_info

    def get_pre_upgrade_check_result(self):
        flag = False
        stdouts = self.diagnose(self.notify)
        if re.search("finished", stdouts[0], re.IGNORECASE):
            flag = True
        elif re.search("fault", stdouts[0], re.IGNORECASE):
            flag = False
        else:
            flag = 'commond_invalid'
        return flag

    def pre_upgrade_check(self):
        flag1 = False
        for i in range(3):
            ret0 = self.get_pre_upgrade_check_result()
            if isinstance(ret0, str) and ret0 == 'commond_invalid':
                print("True\n")
                print("not support")
                return True
            elif ret0:
                flag1 = True
                break
        if not flag1:
            print("False")
            return False
        else:
            print("True")
            return True


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='manual to this script')
    parser.add_argument('mode', type=int)
    mode = parser.parse_args().mode
    ret = Preupgrade_check(mode).pre_upgrade_check()
