#!/usr/bin/python
# coding=utf-8

import subprocess
import re
import datetime
import time

GET_DEVM_PRO = '/OSM/coffer_bin/upg_check/check_item/get_devm_pro_num.sh'


class Preupgrade_check:

    def __init__(self):
        self.notify = 'dpl notifypreupgradecheck'
        self.get = 'dpl getpreupgradecheck'

    def diagnose_usr(self, command, timeout=30):
        starttime = datetime.datetime.now()
        # 执行sh脚本查询devm进程号
        dev = subprocess.Popen(["sh", GET_DEVM_PRO], shell=False, stdout=subprocess.PIPE)
        stdout = dev.communicate()
        devm_info = stdout[0].decode("utf-8")
        match = re.search("Devm Pro num is ([0-9]+)", devm_info)
        if match:
            devm_num = match.group(1)
        else:
            devm_num = "21"
        cmd = 'diagsh --attach=*_%s --cmd="%s" | grep -v "diagsh>"' % (devm_num, command)
        # 创建线程执行dianose命令
        fd = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
        while fd.poll() is None:
            time.sleep(0.1)
            endtime = datetime.datetime.now()
            # 如果达到超时时间，则退出
            if (endtime - starttime).seconds > timeout:
                return "False"
        stdout = fd.communicate()
        cmd_info = stdout[0].decode("utf-8").split('\n')
        return cmd_info

    # 通知升级前检查
    def notify_pre_upgrade_check(self):
        ret = False
        stdouts = self.diagnose_usr(self.notify)
        # 通过回显判断是否通知完成
        if re.search('finished', stdouts[0], re.IGNORECASE):
            ret = True
        elif re.search("found", stdouts[0], re.IGNORECASE):
            ret = 'commond_invalid'
        return ret

    # 获取升级前检查结果
    def get_pre_upgrade_check(self):
        ret = False
        stdouts = self.diagnose_usr(self.get)
        if re.search('True', stdouts[0]):
            ret = True
        elif re.search('Fault', stdouts[0], re.IGNORECASE):
            return stdouts[0]
        return ret

    # 通知升级前检查重试，如果结果不为ok，则重试。
    # 每次重试为30s，重试间隔为10s，重试次数为5次
    def notify_pre_upgrade_check_retry(self, timeout=40):
        notify = False
        invalid_retry = 0
        for i in range(5):
            start = datetime.datetime.now()
            ret = self.notify_pre_upgrade_check()
            # 如果DMI不支持，则返回成功
            if isinstance(ret, str) and ret == 'commond_invalid':
                # 进程故障时，接口返回不支持。所以需要进行一次重试来覆盖
                if invalid_retry > 0:
                    print('True\n')
                    print('Not Support')
                    return False
                invalid_retry += 1
            # 如果通知结果为ok，则返回成功
            elif ret:
                notify = True
                return notify
            end = datetime.datetime.now()
            # 如果未达到超时时间（40s），则休眠;超过则直接退出
            if (end - start).seconds < timeout:
                time.sleep(timeout - (end - start).seconds)
        # 如果重试后依然失败，则返回失败并打印
        if not notify:
            print('False\n')
            print('Error')
            return False

    # 获取升级前检查结果重试，如果结果不为全ok或者故障，则重试。
    # 每次重试为30s，重试间隔为10s，重试次数为5次
    def get_pre_upgrade_check_result_retry(self, timeout=40):
        check = False
        for j in range(5):
            start = datetime.datetime.now()
            ret = self.get_pre_upgrade_check()
            if isinstance(ret, str):
                check = ret
                break
            elif ret:
                check = True
                break
            end = datetime.datetime.now()
            # 如果未达到超时时间（40s），则休眠;超过则直接退出
            if (end - start).seconds < timeout:
                time.sleep(timeout - (end - start).seconds)
        # 返回Fault,则打印故障
        if isinstance(check, str):
            print('False\n')
            print(check)
            return False
        # 返回失败,则打印失败
        elif not check:
            print('False\n')
            print('Error')
            return False
        else:
            print('True\n\n')
            return check


if __name__ == "__main__":
    # 1）下发通知，通知失败则退出，内部有打印
    ret = Preupgrade_check().notify_pre_upgrade_check_retry()
    # 2)下发通知成功，则获取通知检查结果
    # 下发后，驱动可能不能立即返回结果，所以这里等待5s后再去获取结果
    if ret:
        time.sleep(5)
        Preupgrade_check().get_pre_upgrade_check_result_retry()
