#!/bin/bash
#����ͷ�ű�
source /OSM/script/os_load_base.sh

UPGRADE_SH=roll_upgrade_preck.sh
G_CUR_YML_FILE=/startup_disk/image/pkg_cur/manifest.yml
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
G_PRODUCT_INI=/OSM/conf/product.ini
G_DISK_UTIL=/tmp/diskusagetmp
G_DISK_ID=/tmp/diskidtmp
G_DISK_INFO=/tmp/diskinformation
G_ULTRA_CHECK=/tmp/ultraCheck
G_CPU_USAGE=/tmp/cpuusagetmp

declare -a G_DISK_ID_LIST

GetCPUUsage_QOS()
{
diagnose --auto << EOF
overload_ctrl show cur_cpu_load
quit
EOF
}

OS_ExecDiagnose()
{
    local L_CMD=$1
    local L_FILE=$2

    if [ "$L_FILE" == "" ]; then
diagnose --auto <<EOF
$L_CMD
quit
EOF
    else
diagnose --auto <<EOF > "$L_FILE"
$L_CMD
quit
EOF
    fi
    return 0
}

# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_FREE_MEM_ENOUGH()
{    
    OS_echo "[$UPGRADE_SH]: begin to check the free mem when upgrade check."

    #check memory is enough
    echo 3 >/proc/sys/vm/drop_caches

    FREE_MEM=`free -m|grep ^Mem|awk '{print $4}'`
    if [ $FREE_MEM -gt 270 ]; then
        echo "True"
        echo ""
        echo "" 
        return 0
    fi  
    echo "False"
    echo "memlow"
    echo "mem must greater than 270M"
    return 0
}

OS_CHECK_DEVICE_FREE_MEM_ENOUGH()
{
    # device type free mem requirement relationship
    MEMORY_DEVS_180=("5210F V5" "5310F V5")
    MEMORY_DEVS_200=("5510F V5")
    MEMORY_DEVS_270=("5610F V5"  "5810F V5" "6810F V5")
    MEMORY_DEVS_400=("18510F V5" "18810F V5")

    OS_echo "[$UPGRADE_SH]: begin to check the free mem for diff devs when upgrade check."
    # get free mem
    echo 3 >/proc/sys/vm/drop_caches
    FREE_MEM=`free -m|grep ^Mem|awk '{print $4}'`

    # get requied free mem due to device type
    MEM_REQ=270
    DEV_TYPE=`cat ${G_PRODUCT_INI} | grep ProductName | grep = | sed -n '1p' | sed 's/.*=//g' | sed 's/^\s*//;s/\s*$//'`
    echo ${MEMORY_DEVS_180[@]} | grep "${DEV_TYPE}" >/dev/null && MEM_REQ=180
    echo ${MEMORY_DEVS_200[@]} | grep "${DEV_TYPE}" >/dev/null && MEM_REQ=200
    echo ${MEMORY_DEVS_270[@]} | grep "${DEV_TYPE}" >/dev/null && MEM_REQ=270
    echo ${MEMORY_DEVS_400[@]} | grep "${DEV_TYPE}" >/dev/null && MEM_REQ=400

    if [ $FREE_MEM -gt $MEM_REQ ]; then
        echo "True"
        echo ""
        echo ""
        return 0
    fi
    # echo False and self-define error code, error parameters
    echo "False"
    echo "10002"
    echo "${FREE_MEM};${MEM_REQ}"
    return 0
}

OS_CHECK_CPU_USAGE()
{   
     #���dha�����У���Ҫ��ֹͣdha, �˽ű���BDMά�����˴�ֻ������ã������Ľ����
    if [ -f /OSM/script/bdm_stop_dha_aimodel.sh ]
    then
        chmod +x /OSM/script/bdm_stop_dha_aimodel.sh
        /OSM/script/bdm_stop_dha_aimodel.sh
    fi

    sleep 10

    #cpu���ǰ����auto_tiering�ٶȣ�Э����V5R7C20���ӣ�������ִ�н��,sleep 10s�����cpu���
    nas_proto_pum -m auto_tiering -c set_need_control_speed -v 1 &>/dev/null
    sleep 10
    
    #����QOS��diagnose������CPU������
    [ -f $G_CPU_USAGE ] && rm $G_CPU_USAGE
    local var=0
    local count=0
    for((i=0;i<20;i++))
    do
        GetCPUUsage_QOS > $G_CPU_USAGE
        tmpvar=`cat $G_CPU_USAGE |grep "CPU load average" |awk '{print $4}'`
        if [ -n "$tmpvar" ]; then
          var=$(expr $var + $tmpvar)
          count=$(expr $count + 1)
          if [ $count -eq 10 ]; then
            break
          fi
        fi
        sleep 1
    done
    if [ "$count" -lt 10 ]; then
        echo "False"
        echo "10003"
        echo "NA;50"
        return 0
    fi
    L_CUR_CPU_USING=$(expr $var / 10 )
    #cpu����ָ�auto_tiering�ٶȣ�Э����V5R7C20���ӣ�������ִ�н��
    nas_proto_pum -m auto_tiering -c set_need_control_speed -v 0 &>/dev/null
    echo "$L_CUR_CPU_USING"
    echo ""
    echo ""
    return 0
}

# **************************************************************************** #
# Function Name: GetDiskUsage
# Description: check if the disk usage is more than threshold in V5R7C60SPC100 or earlier versions
# Parameter:
# Return:
# **************************************************************************** #
GetDiskUsage()
{
diagnose_usr --auto << EOF > $G_DISK_UTIL
attach 12
sddebug userate 60
quit
EOF
}

#�жϵ�ǰ���а汾���Ƿ���Ŀ��汾�ŵĺ������У�����ں��������򷵻�0���������ݣ����ں������򶼼��ݣ�����1
UPGRADE_SYS_NOT_COMPATIBLE()
{
    OS_echo "[$UPGRADE_SH]: UPGRADE_SYS_NOT_COMPATIBLE">/dev/null    
    L_CUR_VERSION_STR=`cat $G_CUR_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}' | sed 's/[[:space:]]//g'`
    OS_echo "[$UPGRADE_SH]: cur version $L_CUR_VERSION_STR">/dev/null
    
    declare -i L_CUR_VERSION=0
    declare L_VERSION_RANGE=""
    
    L_VERSION_RANGE=`cat $G_PKG_YML_FILE |grep -m 1 BlackVersionList |awk -F":" '{print $2}' | sed 's/[[:space:]]//g' | sed -e 's/^["]*//g' -e 's/["]*$//g'`
    OS_echo "[$UPGRADE_SH]: black list $L_VERSION_RANGE">/dev/null

    #����ȡ�İ汾���е�.��Tȥ��, ��������, ���бȽ�
    L_CUR_VERSION=`echo "$L_CUR_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
        
        
    declare -i Index=1
    ComFirst=`echo $L_VERSION_RANGE|awk -F";" '{print $'$Index'}'` 
    OS_echo "upgrade ComFirst $ComFirst">/dev/null 
    while [ -n "$ComFirst" ] ;do
        declare -i ComVerlow=`echo $ComFirst|awk -F"-" '{print $1}'`
        OS_echo "upgrade ComVerlow $ComVerlow">/dev/null 
        declare -i ComVerhig=`echo $ComFirst|awk -F"-" '{print $2}'`
        OS_echo "upgrade ComVerhig $ComVerhig">/dev/null 
        #�ں������У�����0
        if [ $ComVerlow -eq 6200811000 ] && [ $ComVerhig -eq 9999999999 ]; then
            OS_echo "Ignore this version range">/dev/null
        elif [ $L_CUR_VERSION -ge $ComVerlow ] && [ $L_CUR_VERSION -le $ComVerhig ];then
            return 0
        fi
        #�Է�ŷָ�ж���һ������������
        Index=Index+1
        ComFirst=`echo $L_VERSION_RANGE|awk -F";" '{print $'$Index'}'`
    done
    OS_echo "${UPGRADE_SH} : not in black list">/dev/null
    return 1
}

# **************************************************************************** #
# Function Name: UPGRADE_SYS_VER_BALCK
# Description: �Ƚϰ汾������
# Parameter:
# Return:
# **************************************************************************** #
UPGRADE_SYS_VER_BALCK()
{
    OS_echo "[$UPGRADE_SH]: Get Black List">/dev/null
    
    if [ ! -f $G_PKG_YML_FILE ] ; then
        echo "False"
        echo "pkgerror"
        return 0
    fi
    
    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
    
    if [ ! -d "/startup_disk/image/$L_PKG_VERSION" ];then
        echo "False"
        echo ""
        return 0
    fi
        
    UPGRADE_SYS_NOT_COMPATIBLE
    if [ "$?" == "0" ] ; then
        echo "False"
        return 0
    else
        echo "True"
        return 0
    fi
    
}


#�������뵱ǰ�汾һ��ʱ��鵱ǰ�̼��ļ�����
UPD_COMPARE_SYS_VER()
{    
    L_CUR_VERSION_STR=`cat $G_CUR_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
    OS_echo "[$UPGRADE_SH]: upgrade:cur version $L_CUR_VERSION_STR">/dev/null
    declare -i L_CUR_VERSION=0
    L_CUR_VERSION=`echo "$L_CUR_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`

    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
    OS_echo "[$UPGRADE_SH]: upgrade:pkg version $L_PKG_VERSION_STR">/dev/null
    declare -i L_PKG_VERSION=0
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
    
    #��ȡSYS�汾�Ƿ���ͬ
    if [ $L_CUR_VERSION -eq $L_PKG_VERSION ];then
        return 1
    fi
    
    return 0
}

#����ǰ���ϵͳ�汾�������ͬ����������
UPD_CHECK_SYS_VER()
{
    OS_echo "[$UPGRADE_SH]: Check sys version">/dev/null
    
    UPD_COMPARE_SYS_VER
    ret=$?

    #�汾��ͬ������False
    if [ $ret -eq 1 ];then
        echo "False"
    else
        echo "True"
    fi

    return 0
}

#�ж��Ƿ�Ϊ����
CHECK_IS_DOWNGRADE()
{
    OS_echo "[$UPGRADE_SH]: Check whether the downgrade">/dev/null
    
    L_CUR_VERSION_STR=`cat $G_CUR_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
    OS_echo "[$UPGRADE_SH]: upgrade:cur version is $L_CUR_VERSION_STR">/dev/null
    declare -i L_CUR_VERSION=0
    L_CUR_VERSION=`echo "$L_CUR_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`

    L_PKG_VERSION_STR=`cat $G_PKG_YML_FILE |grep -m 1 Version |awk -F":" '{print $2}'`
    OS_echo "[$UPGRADE_SH]: upgrade:pkg version is $L_PKG_VERSION_STR">/dev/null
    declare -i L_PKG_VERSION=0
    L_PKG_VERSION=`echo "$L_PKG_VERSION_STR" | sed 's/[.T]//g' | sed 's/[[:space:]]//g'`
    
    
    #����������1
    if [ $L_CUR_VERSION -gt $L_PKG_VERSION ];then
        return 1
    fi

    return 0
}

#��������ǰ���ϵͳ�汾������汾��ͬ�����ǽ���������
UPD_CHECK_SYS_VER_WHEN_ONLINE_UPGRADE()
{
    OS_echo "[$UPGRADE_SH]: Check sys version when online upgrade">/dev/null
    
    UPD_COMPARE_SYS_VER
    ret=$?
    
    #�汾��ͬ,����������
    if [ $ret -eq 1 ];then
        echo "False"
    else
        CHECK_IS_DOWNGRADE
        ret=$?
        #��������������Success����������������Lower
        if [ $ret -eq 0 ];then
            echo "True"
        else
            echo "False"
        fi
    fi

    return 0
}


#���澯�Ƿ���ڣ������򷵻�1���������򷵻�0
UPGRADE_CHECK_ALARM_STATE()
{
    OS_echo "${UPGRADE_SH}: EXEC diagnose" >/dev/null
(
diagnose --auto <<EOF
alarm querybyid $1 1 $2
quit
EOF
)>/OSM/update/upgradealarminfo

    #���澯�Ƿ���ڣ������򷵻�1���������򷵻�0
    local L_ALARM_NUMBER=$(grep "Alarm Record Number is" /OSM/update/upgradealarminfo | grep -oE "[0-9]+")

    if [ -z "$L_ALARM_NUMBER" ];then
        OS_echo "${UPGRADE_SH}: Alarm $1 not exist !" >/dev/null
        return 0
    fi

    if [ "$L_ALARM_NUMBER" != "0" ];then
        OS_echo "${UPGRADE_SH}: Alarm $1 exist !" >/dev/null
        return 1
    fi

    OS_echo "${UPGRADE_SH}: Alarm $1 not exist !" >/dev/null
    
    return 0
}

CheckIfAllUltraPath()
{
swm_diagnose --auto << EOF > $G_ULTRA_CHECK
hostlink isallultrapath
quit
EOF
}

#����·���澯
UPGRADE_CHECK_ULTRA_PATH()
{
    local L_RetryTimes=24
    local L_SleepTime=0
    local L_WaitTime=0
    local L_OldAlarmRet=0
    local L_NewAlarmRet=0

    ##�ȴ���·���澯�ָ������6����
    while [ true ]
    do
        if [ ${L_RetryTimes} -eq 0 ];then
            OS_echo "${UPGRADE_SH}: Sleep 6min and ultra path alarm exist." >/dev/null
            return 1;
        fi

        #���͵��������ѯ��·�����ϸ澯�������򷵻�1���������򷵻�0
        #��V500R007C70֮ǰʹ����ID
        UPGRADE_CHECK_ALARM_STATE "64425885721" "1"
        let L_OldAlarmRet=$?
        #��V500R007C70�Լ�֮��İ汾ʹ����ID
        UPGRADE_CHECK_ALARM_STATE "64425885748" "1"
        let L_NewAlarmRet=$?

        #����и澯���6���ӵȴ���·�ָ�
        if [ 1 == $L_OldAlarmRet ] || [ 1 == $L_NewAlarmRet ];then
            sleep 15
        else
            break;
        fi

        let "L_RetryTimes-=1"
        let "L_SleepTime+=15"
    done
    let L_WaitTime=360-${L_SleepTime}
    OS_echo "${UPGRADE_SH}: Wait time is ${L_WaitTime}." >/dev/null

    CheckIfAllUltraPath
    diagnoseResult=$(cat $G_ULTRA_CHECK) 
    OS_echo "${UPGRADE_SH}: Check result is: (${diagnoseResult})." >/dev/null
    
    rm $G_ULTRA_CHECK >/dev/null
    checkResult=$(echo "${diagnoseResult}" | grep 'True')
    #����True������ȫ����װ�˶�·��������ֱ�ӷ��أ�����ȴ�
    if [ -n "${checkResult}" ];then
        OS_echo "${UPGRADE_SH}: All host have beed installed ultrapath, no need to wait ${L_WaitTime}s." >/dev/null
        return 0
    fi
    OS_echo "${UPGRADE_SH}: Some host have not beed installed ultrapath, need to wait ${L_WaitTime}s." >/dev/null
    sleep ${L_WaitTime}
    return 0
}


# **************************************************************************** #
# Function Name: OS_CheckSSDAndSASDiskUsage
# Description: check SSD and SAS disk usage
# Parameter:
# Return:
# **************************************************************************** #
OS_CheckSSDAndSASDiskUsage()
{
    local -i L_OneDiskUsage=0
    local -i L_SSDDiskUtilUsageResult=0
    local -i L_SSDDiskCount=0
    local -i L_SSDDiskAverage=0
    local -i L_SSDDiskSum=0
    local -i L_SSDDiskAverageThreshold=60
    local -i L_SSDDiskMaxThreshold=80
    
    local -i L_SASDiskUtilUsageResult=0
    local -i L_SASDiskCount=0
    local -i L_SASDiskAverage=0
    local -i L_SASDiskSum=0
    local -i L_SASDiskAverageThreshold=60
    local -i L_SASDiskMaxThreshold=80
    L_DiskType=""
    local L_OverThresholdDiskList=""
    local -i MaxL_OverThresholdDiskListLen=256
    
    [ -f $G_DISK_UTIL ] && rm $G_DISK_UTIL
    GetDiskUsage    
    while read sdid util type; 
    do
        if [ -n "$(echo $sdid | grep [a-zA-Z])" -o -z "$sdid" ]; then
            OS_echo "${UPGRADE_SH}: sdid=$sdid"
            continue;
        fi
        L_OneDiskUsage=$util
        L_DiskType=$type
        OS_echo "${UPGRADE_SH}: sdid=$sdid  util=${L_OneDiskUsage} type=${L_DiskType}"
        if [ "${L_DiskType}" == "SSD" ] || [ "${L_DiskType}" == "SLC_SSD" ] || [ "${L_DiskType}" == "MLC_SSD" ]; then
            [ ${L_OneDiskUsage} -gt ${L_SSDDiskUtilUsageResult} ] && L_SSDDiskUtilUsageResult=${L_OneDiskUsage}
            L_SSDDiskCount=$(( $L_SSDDiskCount + 1 ))
            L_SSDDiskSum=$(($L_SSDDiskSum + $L_OneDiskUsage ))
            if [ ${L_OneDiskUsage} -gt ${L_SSDDiskMaxThreshold} ];then
                L_OverThresholdDiskList=${L_OverThresholdDiskList}","$sdid
            fi
        else
            [ ${L_OneDiskUsage} -gt ${L_SASDiskUtilUsageResult} ] && L_SASDiskUtilUsageResult=${L_OneDiskUsage}
            L_SASDiskCount=$(( $L_SASDiskCount + 1 ))
            L_SASDiskSum=$(($L_SASDiskSum + $L_OneDiskUsage ))
            if [ ${L_OneDiskUsage} -gt ${L_SASDiskMaxThreshold} ];then			    
                L_OverThresholdDiskList=${L_OverThresholdDiskList}","$sdid
            fi
        fi
    done < $G_DISK_UTIL &>/dev/null
    
    OS_echo "${UPGRADE_SH}: L_SSDDiskCount=$L_SSDDiskCount  L_SASDiskCount=$L_SASDiskCount"
    # �������ƽ��������
    if [ "0" != "$L_SSDDiskCount" ];then
        L_SSDDiskAverage=$(( $L_SSDDiskSum / $L_SSDDiskCount ))
    fi
    if [ "0" != "$L_SASDiskCount" ];then
        L_SASDiskAverage=$(( $L_SASDiskSum / $L_SASDiskCount ))
    fi
    
    # ȥ��','
    if [ ${#L_OverThresholdDiskList} > 0 ]; then
        L_OverThresholdDiskList=${L_OverThresholdDiskList:1}
    fi  
    
    # ������ȳ���256���ַ�����ȡ256���ַ���Ȼ���'...'    
    if [ ${#L_OverThresholdDiskList} -gt ${MaxL_OverThresholdDiskListLen} ]; then
        L_OverThresholdDiskList=${L_OverThresholdDiskList:0:${MaxL_OverThresholdDiskListLen}}"..."
    fi
        
    if [ ${L_SASDiskUtilUsageResult} -gt ${L_SASDiskMaxThreshold} -o ${L_SASDiskAverage} -gt ${L_SASDiskAverageThreshold} \
       -o ${L_SSDDiskUtilUsageResult} -gt ${L_SSDDiskMaxThreshold} -o ${L_SSDDiskAverage} -gt ${L_SSDDiskAverageThreshold} ]; then
        # echo False and self-define error code, error parameters
        echo "False"
        echo "10004"
        echo "${L_SASDiskUtilUsageResult}%;${L_SASDiskMaxThreshold}%;${L_SASDiskAverage}%;${L_SASDiskAverageThreshold}%;${L_SSDDiskUtilUsageResult}%;${L_SSDDiskMaxThreshold}%;${L_SSDDiskAverage}%;${L_SSDDiskAverageThreshold}%;${L_OverThresholdDiskList}"
        return 0
    fi
    echo "True"
    echo ""
    echo ""
    return 0
}

# --------------------------  main  ------------------------------------------ #

#Ϊ�˵���OS_SET_DISK_RW
OS_GetDriverID

L_INPUT_PARA_NUM=$#

if [ $L_INPUT_PARA_NUM -lt 1 ] ; then
    OS_echo "${UPGRADE_SH}: [os_system_update.sh]wrong input num: $#." >/dev/null
else
        L_TMP=`echo $1 | grep '\-[a-zA-Z0-9]'`
    if [ -z "$L_TMP" ] ; then
        OS_echo "${UPGRADE_SH}: [os_system_update.sh]wrong input para $1." >/dev/null
    fi
fi

while getopts dcbkmMuDK options 2>/dev/null
do
    case $options in
        c)  OS_echo "${UPGRADE_SH} [-c]: Check CPU usage" >/dev/null            
            OS_CHECK_CPU_USAGE
            exit $?
            ;;
        b)  OS_echo "${UPGRADE_SH} [-b]: Get Black List" >/dev/null
            UPGRADE_SYS_VER_BALCK
            exit $?
            ;;
        d)  OS_echo "${UPGRADE_SH} [-d]: Check SSD and SAS usage" >/dev/null
            OS_CheckSSDAndSASDiskUsage
            exit $?
            ;;      
        k)  OS_echo "${UPGRADE_SH} [-k] : Check version " >/dev/null
            UPD_CHECK_SYS_VER
            exit $?
            ;;
        K)  OS_echo "${UPGRADE_SH} [-K] : Check version when online upgrade " >/dev/null
            UPD_CHECK_SYS_VER_WHEN_ONLINE_UPGRADE
            exit $?
            ;;
        m)  OS_echo "${UPGRADE_SH} [-m]: Check free memory" >/dev/null
            OS_CHECK_FREE_MEM_ENOUGH
            exit $?            
            ;;
        M)  OS_echo "${UPGRADE_SH} [-M]: Check device upd require memory" >/dev/null
            OS_CHECK_DEVICE_FREE_MEM_ENOUGH
            exit $?
            ;;  
        u)  OS_echo "${UPGRADE_SH} [-u]: Check Ultra Path" >/dev/null
            UPGRADE_CHECK_ULTRA_PATH 
            exit $?
            ;;
        *) OS_echo "${UPGRADE_SH}: invalid options" >/dev/null
           ;;
    esac
done

exit 0

