﻿# -*- coding:utf-8 -*-
#系统异常重启后工具重连次数
UPGRADE_REBOOT_AFTER_CONNECT_TIMES = 60
#系统异常重启后工具重连间隔时间
UPGRADE_REBOOT_AFTER_CONNECT_INTERVAL = 30
#分发包后状态轮询次数
UPLOAD_PACKAGE_POLL_TIMES = 27*6
#分发包后状态轮询间隔时间
UPLOAD_PACKAGE_POLL_INTERVAL = 10
#执行命令默认超时时间
CMD_DEFAULT_TIMEOUT = 60*5
#下发升级命令后状态轮询次数 
UPGRADE_PACKAGE_POLL_TIMES = 60*6
#下发升级命令后状态轮询间隔时间
UPGRADE_PACKAGE_POLL_INTERVAL = 10
#OM处理失败错误码
OM_OPERATE_FAIL_CODE = 1077949004
#补丁包安全上限，以Byte为单位
PATCH_SAFE_SIZE_V3R3 = 70 * 1024 * 1024

# 升级补丁进程完成后1分钟后会重启升级进程，这时可能导致下发给升级组的命令超时，设置超时时间为10S，并重试
AFTER_UPGRADE_RETRYTIMES = 3
AFTER_UPGRADE_INTERVAL = 5
AFTER_UPGRADE_TIMEOUT = 60

class OM_MSG_OP_UPD_LST_SYS_PROGRESS():
    #SSH: getConnection error code.
    UPD_READY = 0  #初始化状态
    UPD_DLDING = 4 #下载中
    UPD_DLD_SUCCESS = 5 #下载成功
    UPD_DLD_FAIL = 6 #下载失败
    UPD_UPDING = 10 #升级中
    UPD_UPD_SUCCESS = 11 #升级成功
    UPD_UPD_FAIL = 12 #升级失败 
    UPD_ROLLBACKING = 13 #回滚中
    UPD_ROLLBACK_SUCCESS = 14 #回滚成功
    UPD_ROLLBACK_FAIL = 15 #回滚失败   

class PATCH_TYPE():
    ASL_PATCH = 'ASL'
    HOT_PATCH = 'HOT'
    
class TLV_PACKAGE_TYPE():
    ASL_PATCH_PKG = 5
    HOT_PATCH_PKG = 3
    SYS_UPGRADE_PKG = 1#系统升级包类型
    
class CMO_EXE_UPD_MSGTYPE():
    ASL_PATCH_MSGTYPE = 9
    HOT_PATCH_MSGTYPE = 7
    
class TLV_CMD():
    OM_MSG_OP_LST_VER = 8599109735#获取系统版本号
    EXC_UPD = 8599117931
    OM_MSG_OP_GET_PACKAGE_UPLOADPATH = 8599109754
    OM_MSG_OP_UPD_LST_SYS_PROGRESS = 8599109744
    OM_MSG_OP_NOTIFY_PACKAGE_PATH = 8599117947
    OM_MSG_OP_UPD_LIST_DETAILINFO = 8599150995
    GET = 55834574848
    GET_BATCH_NEXT = 55834624000#批量查询对象
    
class TLV_OM_OBJ_E():
    SYSTEM = 201
    FAN_CTRL_MODULE = 306

class FAN_CTRL_MODULE():
    fanCtrlModule = {
                        'type':0,#, 
                        'id':1,#, 
                        'name':2,#, 
                        'parentType':3,#, 
                        'parentID':4,#, 
                        'location':6,#, 
                        'healthStatus':7,#, 
                        'runningStatus':8,#, 
                        'count':10,#, 
                        'elabel':65,#电子标签,
                        'pcbVer':66,#pcb版本
                }
        
class ProductModel():
    modelMap = {0:"V1500",
                1:"V1800",
                2:"S2100",
                3:"S2300",
                4:"S5100",
                5:"S5300",
                6:"S5500",
                7:"S5600",
                8:"VIS",
                9:"S2600",
                10:"S6800E",
                11:"V1500N",
                12:"S2300E",
                13:"COMMON",
                15:"N8000",
                16:"S6900",
                17:"S3900",
                18:"S5500T",
                19:"S5600T",
                20:"S6800T",
                21:"S6900_M100",
                22:"S3900_M200",
                23:"S3900_M300",
                24:"S5900_M100",
                25:"S8100",
                26:"S5800T",
                27:"V1600N",
                28:"S5900_M200",
                29:"N8001",
                30:"S2600T",
                31:"S8000_I",
                32:"Dorado5100",
                33:"T3200",
                34:"T3500",
                35:"N8000-R710",
                36:"N8000-C2",
                40:"N8000-C2-SYMC",
                41:"VTL",
                42:"S2900",
                43:"S2200T",
                44:"Dorado2100",
                45:"VIS",
                46:"HVS85T",
                47:"HVS88T",
                48:"N9000",
                49:"T3200",
                50:"T3500",
                51:"T3200",
                52:"T3500",
                53:"S5700",
                54:"CE6800",
                55:"CE12800",
                56:"HVS_18800F",
                57:"HVS_18500",
                58:"HVS_18800",
                60:"SSS",
                61:"6800V3",
                62:"6900V3",
                63:"5600V3",
                64:"5800V3",
                65:'T3200MINI',
                66:'WUSHAN_SQL',
                67:'WUSHAN_HD',
                68:'5500V3',
                69:'2600V3',
                70:'5300V3',
                71:'2800V3',
                72:'18500V3',
                73:'18800V3',
                401:'N5000',
                800:'VIS8200',
                801:'VIS8400',
                802:'VIS8600',
                803:'VIS8800',
                }
class ProductModelType():
    typeMap = {'S2200T':'T',
               'S2600T':'T',
               'S5500T':'T',
               'S5600T':'T',
               'S5800T':'T',
               'S6800T':'T',
               '5300V3':'V3',
               '5500V3':'V3',
               '5600V3':'V3',
               '5800V3':'V3',
               '6800V3':'V3',
               '6900V3':'V3',
               'HVS_18500':'18000',
               'HVS_18800':'18000',
               'HVS_18800F':'18000',
               'HVS85T':'18000',
               'HVS88T':'18000',
              }
