# -*- coding: UTF-8 -*-

import re
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from common.constant import *
from common import resourceParse
from common.baseFactory import log
from common import constant
import traceback
# *************************************************************#
# 函数名称: execute
# 功能说明: 查询当前设备已安装热补丁
# 其 他   :  无
# *************************************************************#

def execute(dataDict):
    """
          函数名称: execute
         功能说明: 查询当前设备已安装热补丁
         其 他   :  无
    """
    deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
    context = dataDict.get('context')
    patchType = context.get('patchType_%s'%deviceSN)
    lang = dataDict.get('lang')
    """解析resource文件并保存"""
    resource = resourceParse.execute(lang)
    dataDict["resource"] = resource
    if not patchType:
        return getHotPatchCurVersion(dataDict)
    else:
        #触发阵列端清除临时文件
        clearTmpFile(dataDict)
        
        if patchType == PATCH_TYPE.ASL_PATCH:
            return getAslPatchCurVersion(dataDict)
        elif patchType == PATCH_TYPE.HOT_PATCH:
            return getHotPatchCurVersion(dataDict)
        else:
            log.error(dataDict,u'获取补丁包类型异常   PATCH_TYPE:' +patchType)
            errMsg = resource.get('upload.pkgTypeAbnormality')
            return (False,errMsg)
def getHotPatchCurVersion(dataDict):
    """
    功能说明：查询当前阵列已安装的热补丁版本号
    输入：工具框架上下文
    返回：bool查询成功结果False/True，str热补丁版本号
    """
    tlvCon = dataDict["tlv"]
    msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(TLV_PACKAGE_TYPE.HOT_PATCH_PKG))
    params = TLVUtils.paramList(msgParam0)
    retRecs = tlvCon.getBatchWithRetry(
        constant.TLV_CMD.OM_MSG_OP_LST_VER, params,
        constant.AFTER_UPGRADE_TIMEOUT, constant.AFTER_UPGRADE_RETRYTIMES,
        constant.AFTER_UPGRADE_INTERVAL)
    log.info(dataDict,
             'TLV cmd [%d] send[%s] receive[%s]'
             % (constant.TLV_CMD.OM_MSG_OP_LST_VER,
                str(params), str(retRecs)))
    retRec = retRecs[0]
    curHotPatchVersion = retRec.getParamStrValue(4)
    if not curHotPatchVersion:
        log.error(dataDict,'Get curHotPatchVersion failed')
        return (True,'--')
    context = dataDict["context"]
    context["curHotPatchVersion"] = curHotPatchVersion
    return (True,curHotPatchVersion)
    
def getAslPatchCurVersion(dataDict):
    """
    功能说明：查询当前阵列已安装的异构补丁版本号
    输入：工具框架上下文
    返回：bool查询成功结果False/True，str异构补丁版本号
    """
    curAslPatchVersions = ''
    tlvCon = dataDict["tlv"]
    msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(TLV_PACKAGE_TYPE.ASL_PATCH_PKG))
    params = TLVUtils.paramList(msgParam0)
    recs = tlvCon.getBatch(TLV_CMD.OM_MSG_OP_LST_VER, params, CMD_DEFAULT_TIMEOUT)
    log.info(dataDict,'TLV cmd [%d] send[%s] receive[%s]'%(TLV_CMD.OM_MSG_OP_LST_VER,str(params),str(recs)))
    itemNum = recs.size()
    for index in range(0,itemNum):
        curAslPatchVersioninfo = recs.get(index)
        if index == 0:
            result = curAslPatchVersioninfo.getParamIntValue(0).intValue()
            log.info(dataDict,'getAslPatchCurVersion result:'+str(result))
            if result != 0:
                log.error(dataDict,'Get AslPatchCurVersion failed   result:'+ str(result))
                return (True,curAslPatchVersions)
        else:
            AslPatchName = curAslPatchVersioninfo.getParamStrValue(4)
            log.info(dataDict,'AslPatchName:'+AslPatchName)
            AslPatchVersion = curAslPatchVersioninfo.getParamStrValue(5)
            log.info(dataDict,'AslPatchVersion:'+AslPatchVersion)
            curAslPatchVersions += AslPatchName + ' ' + AslPatchVersion + '; \n'
    return (True,curAslPatchVersions)
def clearTmpFile(dataDict):
    """
    功能说明：下发查询上传升级包路径的TLV命令，用来通知阵列端清除临时文件
    """
    try:
        tlvCon = dataDict["tlv"]
        context = dataDict['context']
        deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
        patchType = context.get("patchType_%s"%deviceSN)
        
        if patchType == PATCH_TYPE.HOT_PATCH:
            pkgType = TLV_PACKAGE_TYPE.HOT_PATCH_PKG
        elif patchType == PATCH_TYPE.ASL_PATCH:
            pkgType = TLV_PACKAGE_TYPE.ASL_PATCH_PKG
        param0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(pkgType))
        param1 = Param(1, ParamType.STRING, "")
        param2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        params = TLVUtils.paramList(param0, param1,param2)
        log.info(dataDict, 'Execute cmd [%d] [%s]'%(TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, str(params)))
    
        #获取补丁包上传路径
        retRec = tlvCon.invoke(TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params, CMD_DEFAULT_TIMEOUT)
    except:
        log.error(dataDict,"clear tmp file exception:%s" %unicode(traceback.format_exc()))
    
