# -*- coding: UTF-8 -*-

from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

from common.baseFactory import *
from common import resourceParse
from common.baseFactory import log 
from common import cliUtils

CMD_DEFAULT_TIMEOUT = 60

def execute(dataDict):

    
    ##执行升级前检查
    return preCheck(dataDict)
    
    
def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    upgradeErrMsg = ''
    itemState = True
    if not recs[0]:
        if "^" in recs[1]:
            errorKey = "NdmpClientConnectCheck.pass"
        else:
            itemState = False
            errorKey = "NdmpClientConnectCheck.error"
    else:
        cliRetDict = cliUtils.getVerticalCliRet(recs[1])
        clientConnectNum = cliRetDict.get('Client Connection')
        if clientConnectNum == '0':
            errorKey = "NdmpClientConnectCheck.pass"
        else:
            itemState = False
            errorKey = "NdmpClientConnectCheck.nopass"
    upgradeErrMsg = resource.get(errorKey)
    return (itemState, upgradeErrMsg, None)

def preCheck(dataDict):
    
    sshCon = dataDict["ssh"]
    
    recs = cliUtils.excuteCmdInDeveloperMode(sshCon,'show service ndmp_connection',True)
    log.info(dataDict,"NdmpClientConnectCheck result:%s"%str(recs[1]))
    return disposeRecs(recs,dataDict)
    
        
    