# -*- coding: UTF-8 -*-
from frame.rest import restDataType

REST_CMD_TIMEOUT = 120
REST_SCOPE_DEFAULT = "0"
##执行TLV命令默认超时时间
CMD_DEFAULT_TIMEOUT = 60*5
   
class Enum():   
    class RestMethod():
        GET = 0  #请求主要用于查询存储管理对象
        POST = 1  #请求主要用于创建存储管理对象
        PUT = 2  #请求主要用于修改存储管理对象属性和对管理对象的特殊操作
        DELETE = 3  #主要用于删除存储管理对象   
    
    ##-----------对象属性的枚举类型-----------
    class HealthStatusEnum:
        UNKNOWN = 0
        NORMAL = 1
        FAULT = 2
        PRE_FAIL = 3
        PART_BROKEN = 4
        DEGRADE = 5
        HAS_BAD_BLOCK = 6
        HAS_ERR_CODE = 7
        CONSISTENT = 8
        INCONSISTENT = 9
        BUSY = 10
        POWER_NO_INPUT = 11
        POWER_NOT_ENOUGH = 12
        SINGLE_LINK_FAULT = 13
        INVALID = 14
        WRITE_PROTECT = 15
    
    class RunningStatusEnum:
        UNKNOWN = 0
        NORMAL = 1
        RUNNING = 2
        NOT_RUNNING = 3
        NOT_EXIST = 4
        HIGH_TEMPERATURE_SLEEP = 5
        STARTING = 6
        POWER_FAILURE_PROTECTING = 7
        SLEEPING = 8
        SPINGUP = 9
        LINK_UP = 10
        LINK_DOWN = 11
        POWER_ON = 12
        POWER_OFF = 13
        PRE_COPY = 14
        COPYBACK = 15
        RECONSTRUCTION = 16
        EXPANSION = 17
        NOT_FORMAT = 18
        FORMATTING = 19
        UNMAPPING = 20
        INITIAL_SYNCHRONIZING = 21
        CONSISTENT = 22
        SYNCHRONIZING = 23
        SYNCHRONIZED = 24
        NOT_SYNCHRONIZED = 25
        SPLIT = 26
        ONLINE = 27
        OFFLINE = 28
        LOCKED = 29
        ENABLE = 30
        DISABLED = 31
        LEVELING = 32
        TO_BE_RECOVERD = 33
        INTERRUPTED = 34
        INVALID = 35
        NOSTART = 36
        QUEUING = 37
        STOP = 38
        COPYING = 39
        COMPLETED = 40
        PAUSE = 41
        REVSYNCHRONIZING = 42
        ACTIVATED = 43
        ROLLBACK = 44
        INACTIVATED = 45
        IDLE = 46
        POWERING_OFF = 47
        CHARGING = 48
        CHARGED = 49
        DISCHARGING = 50
        UPGRADING = 51
        POWER_LOST = 52
        INITIALIZING = 53
        APPLY_CONFIG_CHANGE = 54
        ONLINE_DISABLE = 55
        OFFLINE_DISABLE = 56
        ONLINE_FROZEN = 57
        OFFLINE_FROZEN = 58
        CLOSED = 59
        REMOVING = 60
        INSERVICE = 61
        OUTOFSERVICE = 62
        ERASEMENT_RUNNING_NORMAL = 63
        ERASEMENT_RUNNING_FAIL = 64
        ERASEMENT_RUNNING_SUCCESS = 65
        SUCCESS = 66
        FAILED = 67
        WAITING = 68
        CANCELLING = 69
        CANCELLED = 70
        RUNNING_PREPARE_SYNC = 71
        RUNNING_SYNCHRONINING = 72
        RUNNING_SYNC_FAILED = 73
        MIGRATION_FAULT = 74
        MiGRATING = 75
        MIGRATION_COMPLETED = 76
    
    class LicenseFeatureEnum:
        HYPER_REPLICATION = 24
        HYPER_METRO = 63
        
    
    class IbcEnum():
        PWD_CHANGED = "true"
        KEYPAIR_CHANGED = "true"
        
    class EthPortLogicTypeEnum():
        HOST = 0        #主机端口/业务端口
        EXP = 1         #级联端口
        MNGT = 2        #管理端口
        INNER = 3       #内部端口
        MAINTENANCE = 4     #维护端口
        MNGT_SRV = 5        #管理/业务混合口
        MAINTENANCE_SRV = 6 #维护/业务混合口
        BACKUP_MGR = 7      #备份管理网口
        PRODUCT_STORAGE = 8 #生产存储网口
        BACKUP_STORAGE = 9  #备份存储网口
        ETH_NOT_CONFIG = 10 #未配置角色网口
        IP_SCALE_OUT = 11   #用于IP Scale-Out的网口
    
    class CofigModelEnum():
        SINGLE_CTRL = 0 #单控
        MULTI_CTRL = 1  #多控
        
    class LightStatusEnum():
        ON = 1  
        OFF = 2
        
    class IpTypeEnum():
        IPV4 = 1
        IPV6 = 2
        
    class EncLogicTypeEnum():
        EXP = 0   #级联框（硬盘框）
        CTRL = 1  #控制框
        DSW = 2   #数据交换机
        MSW = 3   #管理交换机
        SVP = 4   #管理服务器
    
    class DataTypeEnum():
        CONFIG_DATA = 3 #配置数据
        
    class ExportTypeEnum():
        MEMORY = 0 #从内存导出
        DISK = 1 #从硬盘导出
        
    class DiskEnum():
        DISK0 = "0"
        DISK1 = "1"
    
    class RecoveryPolicyEnum:
        AUTO = 1
        MANUALLY = 2
        
    class OperationTypeEnum():
        EXPORT = 1  #导出
        
    class FileIdEnum():
        CONFIG_DATA = 50    #配置数据文件
        
    class OperationResultEnum():
        SUCCESS = 0
        FAIL = 1
        
    class ParentTypeEnum():
        ENCLOSURE = 206#框/Enclosure
        CONTROLLER = 207#控制器/Controller
        EXPBOARD = 208#级联板/Expand Board
        INTF_MODULE = 209#接口模块/Interface Module
        
    class EnlosureModelEnum():
            CTRL_BMC = 0    #BMC控制框
            CTRL_SAS2U_12 = 1   #2U SAS 12盘主控框
            CTRL_SAS2U_24 = 2   #2U SAS 24盘主控框 
            EXPSAS2U_12 = 16    #2U SAS 12盘级联框
            EXPSAS2U_24 = 17    #2U SAS 24盘级联框
            EXPSAS4U = 18   #4U SAS 24盘级联框
            EXPFC = 19  #4U FC 24盘级联框
            DSW_PCIe1U = 20 #1U PCIe数据交换机
            EXPSAS4U_75 = 21    #4U SAS 75盘级联框
            SVP = 22    #SVP
            CTRL_6U = 97    #6U 4控独立机头
            CTRL_3U = 96    #3U 2控独立机头
            EXPSAS2U_25 = 24    #2U SAS 25盘2.5寸磁盘框
            EXPSAS4U_24_NEW = 25    #4U SAS 24盘3.5寸磁盘框（新）
            CTRL_12GSAS_2U25_EAR = 26   #2U 12GSAS 25盘主控框
            CTRL_12GSAS_2U12_EAR = 23   #2U 12GSAS 12盘主控框
            ARM_2U_12 = 37  #2U 12GSAS 12盘ARM主控框/
            ARM_2U_25 = 38  #2U 12GSAS 25盘ARM主控框/
    
    class ObjectEnum():
        FC_PORT = 212   #FC端口
        ETH_PORT = 213  #以太网口
        SAS_PORT = 214  #SAS端口
        FCoE_PORT = 252 #FCoE端口
        IB_PORT = 16500 #IB端口
    
    class NetModeEnum():
        UNKNOWN = 0 #无效值
        DIRECT = 1  #直连组网
        SWITCH = 2  #交换机组网
        DIRECT2SWITCH = 3   #直连组网转交换机组网
    
    #---对象参数枚举---
    class TlvObjEnum():
        CONTROLLER = 207
    
    class BmcChangeModeEnum():
        CHANGE = 0
        DELETE = 1
        SET = 2
        SYNC = 3
        
    class UpdMsgTypeEnum():
        PRECHECK = 0
        DOWNLOAD = 1
        ACTIVE_METHOD = 2
        EXEC_UPD = 3
        POSTCHECK = 4
        MANUAL_ROLLBACK = 5
        EXEC_COMPLETE = 6
    
    class UpdActiveType():
        ONLINE = 0
        OFFLINE = 1 
#-------------新增rest参数------------

#---命令字---
class TlvCmd():
    CHANGE_BMC_INFO = {'cmd':56908316708,'timeout':120}#修改BMC信息
    OM_MSG_OP_UPD_EXECUTE = {'cmd':8599117931,'timeout':300}#通知执行一个升级流程
    EXC_UPD = {'cmd':8599117931,'timeout':CMD_DEFAULT_TIMEOUT}#执行命令字，根据下发参数不同执行相应的命令
    VMMS_OPCODE_VMMS_UPD = {'cmd':55847747925,'timeout':CMD_DEFAULT_TIMEOUT} #新增升级前检查项接口
    GET_IS_EXIST_URGENT_ALM_CLEARED = {'cmd':55847747768,'timeout':CMD_DEFAULT_TIMEOUT}#查询是否存在被清除的重要紧急故障告警
    OM_MSG_OP_LST_VER = {'cmd':8599109735,'timeout':CMD_DEFAULT_TIMEOUT}#轮询版本信息命令
    OM_MSG_OP_GET_PACKAGE_INFO = {'cmd':8599109756,'timeout':CMD_DEFAULT_TIMEOUT}#获取升级包信息 
    OM_MSG_OP_UPD_LST_SYS_PROGRESS = {'cmd':8599109744,'timeout':CMD_DEFAULT_TIMEOUT}#查询整体升级状态
    OM_MSG_OP_GET_PACKAGE_UPLOADPATH = {'cmd':8599109754,'timeout':CMD_DEFAULT_TIMEOUT}#查询升级包上传路径
    OM_MSG_OP_NOTIFY_PACKAGE_PATH = {'cmd':8599117947,'timeout':CMD_DEFAULT_TIMEOUT}#网管通知升级包上传路径
    OM_MSG_OP_UPD_LIST_DETAILINFO = {'cmd':8599150995,'timeout':CMD_DEFAULT_TIMEOUT}#查询升级详细信息
    CMO_DB_EXPORT_CONFIG = {'cmd':55847747603, 'timeout':CMD_DEFAULT_TIMEOUT}#导出配置文件
    RECORD_OPERATION_LOG = {'cmd':55847747739, 'timeout':CMD_DEFAULT_TIMEOUT}#记录操作日志，主要用于从设备侧导出文件使用
    GET_LICENSE_EXPORT_PATH = {'cmd':55850565645, 'timeout':CMD_DEFAULT_TIMEOUT}#
    GET_BATCH = {'cmd':55834624000,'timeout':300}#轮询版本信息命令
    GET = {'cmd':55834574848,'timeout':300}#
    

class DaignoseCmd():
    """
    @summary: cmd:diagnose命令; checkModel检查模式（1：只检查主控；2：检查所有控制器）
    """
    IS_MEMUSEDUP = {'cmd':"sys ismemusedup", 'checkModel':2}
    IS_SAMEVER = {'cmd':"upd issameversion", 'checkModel':2}
    IS_DOUBLECTRL = {'cmd':"sys isalldoublectrl", 'checkModel':2}
    IS_SYSNORMAL = {'cmd':"sys issysnormal", 'checkModel':1}
    IS_POOLUPGRADE = {'cmd':"pmgr isallpoolcanupgrade", 'checkModel':2}
    IS_SYSBUSY = {'cmd':"sys issystembusy", 'checkModel':1}
    
    CHECK_BBUPOWER = {'cmd':"upg checkbbupower", 'checkModel':2}
    CHECK_DISKSLOW = {'cmd':"ld checkdiskslow", 'checkModel':1}
    CHECK_SYSCOMPATIBLE = {'cmd':"upd syscompatiblecheck", 'checkModel':2}
    CHECK_ALARM = {'cmd':"upg UrgentAlm", 'checkModel':1}
    CHECK_BLACK_WHITE_LSIT = {'cmd':"upd checkblackwhitelist", 'checkModel':2}
    CHECK_DISKUSAGE = {'cmd':"upd diskusagecheck", 'checkModel':2}
    CHECK_IOBANDWIDTH = {'cmd':"ioperf iobandwidth 5", 'checkModel':2}
    CHECK_SINGLELINK = {'cmd':"ld checksinglelink", 'checkModel':2}
    CHECK_EXTLUNLINK = {'cmd':"ld checkextlunsinglelink", 'checkModel':1}
    CHECK_FWVERINFO = {'cmd':"upg checkfwverinfo", 'checkModel':2}
    CHECK_SYSRESOURCE = {'cmd':"upd sysresourcecheck", 'checkModel':2}
    CHECK_DIAG = {'cmd':"sddebug checkdiag", 'checkModel':2}
    CHECK_VERSION = {'cmd':"upg checkversion", 'checkModel':1}
    CHECK_XNETPRESSURE = {'cmd':"xnet checkpressure", 'checkModel':2}
    CHECK_HOTPACH = {'cmd':"upg hotpachcheck", 'checkModel':2}
    
    SHOW_UPDATE = {'cmd':"rsf showupdate", 'checkModel':1}
    

class Uri():
    TLV_COMMUNICATION = "ToolkitRequest/TLVCommunication"

class ErrorInfo():
    CODE = {"key":"code","type":restDataType.DATA_TYPE_STRING}
    DESCRIPTION = {"key":"description","type":restDataType.DATA_TYPE_STRING} 

#---对象参数属性---
class PublicAttributes():
    TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
    ID = {"index":1,"type":restDataType.DATA_TYPE_STRING}
    NAME= {"index":2,"type":restDataType.DATA_TYPE_STRING}
    PARENT_TYPE= {"index":3,"type":restDataType.DATA_TYPE_ENUM}
    PARENT_ID = {"index":4,"type":restDataType.DATA_TYPE_STRING}
    PARENT_NAME = {"index":5,"type":restDataType.DATA_TYPE_STRING}
    LOCATION = {"index":6,"type":restDataType.DATA_TYPE_STRING}
    HEALTH_STATUS = {"index":7,"type":restDataType.DATA_TYPE_ENUM}
    RUNNING_STATUS = {"index":8,"type":restDataType.DATA_TYPE_ENUM}
    
class Hardware():
    '''
    Description: 机框
    '''
    class Enclosure(PublicAttributes):
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        MODEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#型号
        LOGIC_TYPE = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#类型
        TEMPERATURE = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度
        SERIAL_NUM = {"index":68, "type":restDataType.DATA_TYPE_STRING}#序列号
        MAC_ADDRESS = {"index":69, "type":restDataType.DATA_TYPE_STRING}#MAC地址
        HEIGHT = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#高度
        EXPANDER_DEPTH = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#级联深度
        EXPANDER_PORT = {"index":72, "type":restDataType.DATA_TYPE_STRING}#SAS域或FC环路
        SWITCH = {"index":73, "type":restDataType.DATA_TYPE_ENUM}#定位灯状态
        SOFT_VER = {"index":76, "type":restDataType.DATA_TYPE_STRING}#Firmware版本
        CPU_USAGE = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#CPU占用率
        MEMORY_USAGE = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#内存使用率
        CHASSIS_PACKAGE_TYPE = {"index":79, "type":restDataType.DATA_TYPE_ENUM}#节点类型
        ELABEL = {"index":80, "type":restDataType.DATA_TYPE_STRING}#电子标签
class Upgrade():
    class BmcInfoDefine():
        FLAG = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
    
    class NotifyExcUpgrade():
        CMO_EXE_UPD_MSGTYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXE_UPD_NIDLIST = {"index":1,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_ACTIVETYPE = {"index":2,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXE_UPD_BAKPATH = {"index":3,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXENODETYPE = {"index":4,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEFLOW = {"index":5,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEFLOWSEGMENT = {"index":6,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEATOM = {"index":7,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_SYNCPAR = {"index":8,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_PKG_TYPE = {"index":9,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_RESULT = {"index":10,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_ERROR_INFO = {"index":11,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_DIAG_CMD = {"index":12,"type":restDataType.DATA_TYPE_STRING}
        CMO_EXC_CHECK_MODEL = {"index":13,"type":restDataType.DATA_TYPE_UNSIGN_INT}
    
    #查询整体升级状态   
    class LstSysProgress():
        CMO_UPD_SYS_MODE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_ID = {"index":1,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_REMAINTIME = {"index":2,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_TASK_STATUS = {"index":3,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_STEP_PERCENT = {"index":4,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
    
    class RecordParam():
        RECORD_NODE_ID = {"index":0,"type":restDataType.DATA_TYPE_STRING}
        RECORD_RESULT = {"index":1,"type":restDataType.DATA_TYPE_STRING}
        
    class GetPackageUploadPath():
        CMO_PACKAGE_TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_PACKAGE_DIR_FILE = {"index":1,"type":restDataType.DATA_TYPE_STRING}
        CMO_PACKAGE_SIZE = {"index":2,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        
    class NotifyPackagePath():
        CMO_NOTIFY_PACKAGE_PATH = {"index":0,"type":restDataType.DATA_TYPE_STRING}
    
    #查询升级详细信息    
    class UpdListDetaiInfo():
        NAME_KEY = {"index":0,"type":restDataType.DATA_TYPE_STRING}
        ITEM_STATE = {"index":1,"type":restDataType.DATA_TYPE_STRING}
        ERROY_KEY = {"index":2,"type":restDataType.DATA_TYPE_STRING}
        NODE_ID = {"index":3,"type":restDataType.DATA_TYPE_STRING}
    
    class UpdLstSysProgress():
        CMO_UPD_SYS_MODE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPD_SYS_STEP_ID = {"index":1,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_REMAINTIME = {"index":2,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_TASK_STATUS = {"index":3,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPD_SYS_STEP_STEP_PERCENT = {"index":4,"type":restDataType.DATA_TYPE_UNSIGN_32INT}
        
    class LstVer():
        CMO_VER_PACKAGE_TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_RESULT = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_CUR_VERSION = {"index":4,"type":restDataType.DATA_TYPE_STRING}
        CMO_VER_SAVED_VERSION = {"index":5,"type":restDataType.DATA_TYPE_STRING}
        CMO_VER_CUR_VERSION_FOR_USER = {"index":7,"type":restDataType.DATA_TYPE_STRING}
        CMO_VER_CUR_VERSION_SUPPORT_MODE = {"index":8,"type":restDataType.DATA_TYPE_UNSIGN_INT}
    
    class ExportConfig():
        CMO_EXPORT_DB_TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_EXPORT_DB_DATA_DIR = {"index":2,"type":restDataType.DATA_TYPE_STRING}
        
    class OperationLog():
        OPER_TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        FILE_TYPE = {"index":1,"type":restDataType.DATA_TYPE_UNSIGN_INT}
        RET_VALUE = {"index":3,"type":restDataType.DATA_TYPE_UNSIGN_INT}
    
    #查询License导出路径
    class LicenseExportPath():
        CMO_LICENSE_DIR_INFO_DIR = {"index":0,"type":restDataType.DATA_TYPE_STRING}
    
    #查询升级包信息
    class PackageInfo():
        CMO_PACKAGE_TYPE = {"index":0,"type":restDataType.DATA_TYPE_UNSIGN_INT}#升级包类型
        CMO_PACKAGE_NODE_ID = {"index":1,"type":restDataType.DATA_TYPE_UNSIGN_INT}#节点ID
        CMO_PACKAGE_INNER_VERSION = {"index":2,"type":restDataType.DATA_TYPE_STRING}#系统软件内部版本号
        CMO_PACKAGE_SPC_VERSION = {"index":6,"type":restDataType.DATA_TYPE_STRING}#系统软件外部版本号
    
    #新增升级前检查项接口    
    class VmmsUpd():
        VMMS_UPD_TYPE = {"index":64,"type":restDataType.DATA_TYPE_UNSIGN_INT}#升级包类型
        VMMS_UPD_ISINNER = {"index":67,"type":restDataType.DATA_TYPE_UNSIGN_INT}#节点ID
        
    class UrgentAlmCleared():
        CMO_ALARM_LOCATION = {"index":13,"type":restDataType.DATA_TYPE_UNSIGN_INT}#
        URGENT_ALM_RESULT = {"index":71,"type":restDataType.DATA_TYPE_STRING}
        

class System():
    productMode = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#产品型号
