# -*- coding: UTF-8 -*-
from common.baseFactory import *
from common import resourceParse
from frame.rest.restUtil import Tlv2Rest
from frame.rest import restData

ERR_MAP = {
           'TRUE':{'errkey':'ISFrontBandWidthEnough.pass','result':True},
           'FALSE':{'errkey':'ISFrontBandWidthEnough.notpass','result':False},
           'TIMEOUT':{'errkey':'ISFrontBandWidthEnough.timeout','result':False},
           'ERROR':{'errkey':'ISFrontBandWidthEnough.error','result':False},
}

def execute(dataDict):
    
    ##执行升级前检查
    return preCheck(dataDict)

"""
    查询升级检查项，并更新界面
"""
def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    upgradeErrMsg = ''
    itemState = True
    
    if recs is None or recs.size() == 0:
        return (False, resource.get('ISFrontBandWidthEnough.error'), None)
   
    recNum = recs.size()
    for index in range(0, recNum):
        rec = recs.get(index)
        nodeId = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_NODE_ID)
        result = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_RESULT)
        log.info(dataDict,"[ISFrontBandWidthEnough]result:" + unicode(result))
        result = result.upper()
        checkRet = ERR_MAP.get(result,ERR_MAP.get('ERROR'))
        itemState = itemState and checkRet.get('result')
        errorKey = checkRet.get('errkey')
        upgradeErrMsg += getUpgErrMsg(resource,nodeId,errorKey)
        
    return (itemState, upgradeErrMsg, None)
"""
    执行升级前检查，并更新界面
"""
def preCheck(dataDict):
    recs = executeCheck(dataDict, "ioperf iobandwidth 5", 2)
    return disposeRecs(recs, dataDict)
