# -*- coding: UTF-8 -*-

from cbb.business.checkitems import restrict_task_check
from cbb.frame.base import baseUtil
from cbb.frame.cli import cliUtil
from frame.context import contextUtil
from common import resourceParse


def execute(data_dict):
    if not version_need_check(data_dict):
        return True, '', ''
    lang = data_dict['lang']
    resource = resourceParse.execute(lang)
    flag, recs, errors = restrict_task_check.execute(data_dict)
    if flag == cliUtil.RESULT_NOCHECK:
        return False, resource.get("RestrictTaskCheck.error"), recs
    return flag, errors if flag is True else \
        resource.get("RestrictTaskCheck.notpass") + '\n' + \
        resource.get("RestrictTaskCheck.suggestion"), recs


def version_need_check(context):
    dev_type = context.get('dev').getDeviceType().toString()
    dev_version = context.get('dev').getProductVersion()
    # Dorado V3版本：V300R001C21及之前的版本不涉及（包含TR5版本）
    if baseUtil.isDoradoDev(dev_type):
        if dev_version < "V300R001C21":
            return False
    # 融合存储V3版本：V3R6C20及以后、V5R7C10及以后版本需要支持
    elif dev_version < "V300R006C20":
        return False
    elif dev_version.startswith("V500") and dev_version < "V500R007C10":
        return False
    return True
