# -*- coding: UTF-8 -*-

from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

import time
from common.baseFactory import *
from common import resourceParse
from common.baseFactory import log  
from frame.rest.restUtil import Tlv2Rest
from frame.rest import restData


CMD_DEFAULT_TIMEOUT = 60

def execute(dataDict):
    ##执行升级前检查
    return preCheck(dataDict)


def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    recNum = recs.size()
    versionList=[]
    
    for index in range(0, recNum):
        rec = recs.get(index)
        devVersion = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_RESULT)
        log.info(dataDict,"devVersion:" + devVersion)
        versionList.append(devVersion)
    listLenth = len(versionList)
    
    flag = "True"
    for i in range(0,listLenth):
        for j in range(1,listLenth):
            if versionList[i] == versionList[j]:
                continue
            else:
                flag = "False"
                break
    
    
    if flag == "True":
        #执行成功
        itemState = True
        errorKey = "ISSameVersion.pass"
    else:
        #执行失败
        itemState = False
        errorKey = "ISSameVersion.notpass"
    upgradeErrMsg = resource.get(errorKey)
    
    return (itemState , upgradeErrMsg, None)

def preCheck(dataDict):
        recs = executeCheck(dataDict, "upd issameversion", 2)
        return disposeRecs(recs, dataDict)
