# -*- coding: UTF-8 -*-

from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

from common.baseFactory import *
from common import resourceParse
from common.baseFactory import log 
from frame.rest.restUtil import Tlv2Rest
from frame.rest import restData


CMD_DEFAULT_TIMEOUT = 60

def execute(dataDict):

    
    ##执行升级前检查
    return preCheck(dataDict)
    

def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    recNum = recs.size()
    
    upgradeErrMsg = ''
    itemState = True
    for index in range(0, recNum):
        rec = recs.get(index)
        nodeId = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_NODE_ID)
        result = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_RESULT)
        log.info(dataDict,"SysFaultCheck result:" + result)
        if result == "True":
            #执行成功
            errorKey = "SysFaultCheck.pass"
        elif result == "False":
            #执行失败
            itemState = False
            errorKey = "SysFaultCheck.notpass"
        elif result == "TimeOut":
            #执行超时
            itemState = False
            errorKey = "SysFaultCheck.timeout"
        else:
            #执行出错
            itemState = False
            errorKey = "SysFaultCheck.error"
        upgradeErrMsg += nodeId + '--' + resource.get(errorKey) + '\n'
    if not upgradeErrMsg:
        itemState = False
        upgradeErrMsg = resource.get("SysFaultCheck.error")
    return (itemState, upgradeErrMsg, None)

def preCheck(dataDict):
    
        recs = executeCheck(dataDict, "sys issysnormal", 2)       
        return disposeRecs(recs,dataDict)
