# -*- coding: UTF-8 -*-
import shutil
import os
from hotpatch import XNETOperationModeCheck
from hotpatch import SysResourcePostCheck
from hotpatch import HdsVersionCheck
from hotpatch import SASPatchModeCheck
from common.constant import PATCH_TYPE
from common.baseFactory import log, threadUp , finishProcess
from common.baseFactory import deleteTempPatch

from checkitems import service_netlog_ex_enable_check
from checkitems import check_bbu_alarm_and_status

from checkitems import FdsaTunefsPostCheck

total_remain_time = 23
def execute(dataDict):
    try:
        threadUp(dataDict, "postcheck", total_remain_time)

        deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
        context = dataDict.get("context")
        patchType = context.get("patchType_%s" % deviceSN)
        log.info(dataDict, "deviceSN=%s, patchType:===============%s" % (deviceSN, patchType))
        check_flag = True
        check_msg = ""

        if patchType == PATCH_TYPE.HOT_PATCH:
            processRet = SysResourcePostCheck.execute(dataDict)
            if not processRet[0]:
                check_msg += processRet[1] + "\n"
                check_flag = False

            processRet = XNETOperationModeCheck.execute(dataDict)
            if not processRet[0]:
                check_msg += processRet[1] + "\n"
                check_flag = False

            processRet = HdsVersionCheck.execute(dataDict)
            if not processRet[0]:
                check_msg += processRet[1] + "\n"
                check_flag = False
            flag, msg, __ = service_netlog_ex_enable_check.execute(dataDict)
            if not flag:
                log.info(dataDict, "net log ex error!")
                check_msg = u"{}{}\n".format(check_msg, msg)
                check_flag = False
            processRet = SASPatchModeCheck.execute(dataDict)
            if not processRet[0]:
                check_msg += processRet[1] + "\n"
                check_flag = False
            process_result = check_bbu_alarm_and_status.execute_after(dataDict)
            if not process_result[0]:
                check_msg += process_result[1] + "\n"
                check_flag = False

            process_result = FdsaTunefsPostCheck.execute(dataDict)
            if not process_result[0]:
                check_msg += process_result[1] + "\n"
                check_flag = False
        deleteTempPatch(dataDict)
        return (check_flag, check_msg, None)
    finally:
        finishProcess(dataDict, "postcheck")
