# -*- coding: UTF-8 -*-

from common.baseFactory import *
from common import resourceParse
from common.baseFactory import log
from common import cliUtils
from frame.context import contextUtil

CMD_DEFAULT_TIMEOUT = 60


def execute(dataDict):
    # 执行升级前检查
    return preCheck(dataDict)


def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    upgradeErrMsg = ''
    itemState = True
    if not recs[0]:
        if "^" in recs[1]:
            errorKey = "NdmpClientConnectCheck.pass"
        else:
            itemState = False
            errorKey = "NdmpClientConnectCheck.error"
    else:
        cliRetDict = cliUtils.getVerticalCliRet(recs[1])
        clientConnectNum = cliRetDict.get('Client Connection')
        if clientConnectNum == '0':
            errorKey = "NdmpClientConnectCheck.pass"
        else:
            itemState = False
            errorKey = "NdmpClientConnectCheck.nopass"
    upgradeErrMsg = resource.get(errorKey)
    return (itemState, upgradeErrMsg, None)


def preCheck(dataDict):
    dev_type = contextUtil.getProductModel(dataDict)
    if not is_contain_NDMP_business_type(dev_type):
        log.info(dataDict, "The device type:{} can't contains DNMP "
                           "business".format(dev_type))
        resource = resourceParse.execute(dataDict.get('lang'))
        pass_msg = resource.get("NdmpClientConnectCheck.pass")
        return True, pass_msg, None

    sshCon = dataDict["ssh"]
    recs = cliUtils.excuteCmdInDeveloperMode(sshCon,
                                             'show service ndmp_connection',
                                             True)
    log.info(dataDict, "NdmpClientConnectCheck result:%s" % str(recs[1]))
    return disposeRecs(recs, dataDict)


def is_contain_NDMP_business_type(dev_type):
    """
    是否是包含NDMP业务的型号
    :param dev_type: 设备型号
    :return: True/False
    """
    if "Dorado" not in dev_type:
        return True
    if "NAS" in dev_type:
        return True
    return False
