# -*- coding: UTF-8 -*-


from common.baseFactory import getUpgErrMsg, log, execute_check_retry
from common import resourceParse
from frame.rest.restUtil import Tlv2Rest
from frame.rest import restData

DEVICE_TYPE_V5_LIST = ['5600 V5', '5600F V5', '5800 V5', '5800F V5',
                       '6800 V5', '6800F V5', '18500 V5', '18500F V5', '18800 V5', '18800F V5']
VERSION_V5_LIST = ['V500R007C00', 'V500R007C00SPC100',
                   'V500R007C10', 'V500R007C20',
                   'V500R007C30','V500R007C30SPC100']
DEVICE_TYPE_DORADO_LIST = ['Dorado6000 V3', 'Dorado18000 V3']
VERSION_DORADO_LIST = ['V300R001C21', 'V300R001C21SPC100',
                       'V300R001C30', 'V300R001C30SPC100',
                       'V300R002C00', 'V300R002C00SPC100',
                       'V300R002C10', 'V300R002C10SPC100']

def execute(dataDict):
    ##执行升级前检查
    log.info(dataDict, "begin to check sas patch mode.")
    dev = dataDict.get('dev')
    devType = str(dev.getDeviceType())
    productVersion = str(dev.getProductVersion())
    log.info(dataDict, "SASPatchModeCheck Device type is:" + devType)
    log.info(dataDict, "SASPatchModeCheck Product version is:" + productVersion)
    if 'dorado' in devType.lower():
        if devType not in DEVICE_TYPE_DORADO_LIST or productVersion not in VERSION_DORADO_LIST:
            return (True, "", None)
    else:
        if devType not in DEVICE_TYPE_V5_LIST or productVersion not in VERSION_V5_LIST:
            return (True, "", None)
    return preCheck(dataDict)

"""
    查询升级检查项，并更新界面
"""
def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    upgradeErrMsg = resource.get("SASPatchModeCheck.title") + "\n"
    itemState = True

    if recs is None or recs.size() == 0:
        upgradeErrMsg += resource.get('SASPatchModeCheck.error')
        return (False, upgradeErrMsg, None)

    recNum = recs.size()
    for index in range(0, recNum):
        rec = recs.get(index)
        nodeId = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_NODE_ID)
        result = Tlv2Rest.getRecordValue(rec, restData.Upgrade.RecordParam.RECORD_RESULT)
        log.info(dataDict, "[SASPatchModeCheck]nodeId(%s) result:%s" %(nodeId, result))
        result = result.lower().strip()
        if 'invalid' == result:
            itemState = False
            errorKey = "SASPatchModeCheck.notpass"
            upgradeErrMsg += getUpgErrMsg(resource, nodeId, errorKey)
        elif 'the port id is invaild' in result or 'valid' == result:
            errorKey = "SASPatchModeCheck.pass"
            upgradeErrMsg += getUpgErrMsg(resource, nodeId, errorKey)
        else:
            itemState = False
            errorKey = "SASPatchModeCheck.error"
            upgradeErrMsg += getUpgErrMsg(resource, nodeId, errorKey)

    return (itemState, upgradeErrMsg, None)

"""
    执行升级前检查，并更新界面
"""
def preCheck(dataDict):
    recs = execute_check_retry(dataDict, "drvsascbb showrsc port_id=0x1fffff", 2)
    return disposeRecs(recs, dataDict)