# -*- coding: UTF-8 -*-

import re
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from common.constant import PATCH_TYPE, TLV_PACKAGE_TYPE
from common import resourceParse
from common.baseFactory import log
from cbb.frame.context import contextUtil
from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.rest import restData
import traceback
# *************************************************************#
# # 函数名称: execute
# # 功能说明: 查询当前设备已安装热补丁
# # 其 他   :  无
# # *************************************************************#

def execute(dataDict):
    """
          函数名称: execute
         功能说明: 查询当前设备已安装热补丁
         其 他   :  无
    """
    
    deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
    context = dataDict.get('context')
    patchType = context.get('patchType_%s'%deviceSN)
    lang = dataDict.get('lang')
    """解析resource文件并保存"""
    resource = resourceParse.execute(lang)
    dataDict["resource"] = resource
    if not patchType:
        return getHotPatchCurVersion(dataDict)
    else:
        #触发阵列端清除临时文件
        clearTmpFile(dataDict)
        
        if patchType == PATCH_TYPE.ASL_PATCH:
            return getAslPatchCurVersion(dataDict)
        elif patchType == PATCH_TYPE.HOT_PATCH:
            return getHotPatchCurVersion(dataDict)
        else:
            log.error(dataDict,u'获取补丁包类型异常   PATCH_TYPE:' +patchType)
            errMsg = resource.get('upload.pkgTypeAbnormality')
            return (False,errMsg)
def getHotPatchCurVersion(dataDict):
    """
    功能说明：查询当前阵列已安装的热补丁版本号
    输入：工具框架上下文
    返回：bool查询成功结果False/True，str热补丁版本号
    """
    rest = contextUtil.getRest(dataDict)
    params = []
    msgParam0 = (restData.Upgrade.LstVer.CMO_VER_PACKAGE_TYPE, UnsignedInt32(TLV_PACKAGE_TYPE.HOT_PATCH_PKG))
    params.append(msgParam0)
    recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_LST_VER, params)
    rec = recs[0]
    log.info(dataDict,'TLV cmd [%s] send[%s] receive[%s]'%(unicode(restData.TlvCmd.OM_MSG_OP_LST_VER),str(params),str(rec)))
    curHotPatchVersion = Tlv2Rest.getRecordValue(rec, restData.Upgrade.LstVer.CMO_VER_CUR_VERSION)
    if not curHotPatchVersion:
        log.error(dataDict,'Get curHotPatchVersion failed')
        return (True,'--')
    return (True,curHotPatchVersion)
    
def getAslPatchCurVersion(dataDict):
    """
    功能说明：查询当前阵列已安装的异构补丁版本号
    输入：工具框架上下文
    返回：bool查询成功结果False/True，str异构补丁版本号
    """
    curAslPatchVersions = ''
    
    rest = contextUtil.getRest(dataDict)
    params = []
    msgParam0 = (restData.Upgrade.LstVer.CMO_VER_PACKAGE_TYPE, UnsignedInt32(TLV_PACKAGE_TYPE.ASL_PATCH_PKG))
    params.append(msgParam0)
    recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_LST_VER, params)
    
    log.info(dataDict,'TLV cmd [%s] send[%s] receive[%s]'%(unicode(restData.TlvCmd.OM_MSG_OP_LST_VER),str(params),str(recs)))
    itemNum = recs.size()
    for index in range(0,itemNum):
        curAslPatchVersioninfo = recs.get(index)
        if index == 0:
            result = Tlv2Rest.getRecordValue(curAslPatchVersioninfo, restData.Upgrade.LstVer.CMO_VER_PACKAGE_TYPE)
            log.info(dataDict,'getAslPatchCurVersion result:'+str(result))
            if result != 0:
                log.error(dataDict,'Get AslPatchCurVersion failed   result:'+ str(result))
                return (True,curAslPatchVersions)
        else:
            AslPatchName = Tlv2Rest.getRecordValue(curAslPatchVersioninfo, restData.Upgrade.LstVer.CMO_VER_CUR_VERSION)
            log.info(dataDict,'AslPatchName:'+AslPatchName)
            AslPatchVersion = Tlv2Rest.getRecordValue(curAslPatchVersioninfo, restData.Upgrade.LstVer.CMO_VER_SAVED_VERSION)
            log.info(dataDict,'AslPatchVersion:'+AslPatchVersion)
            curAslPatchVersions += AslPatchName + ' ' + AslPatchVersion + '; \n'
    return (True,curAslPatchVersions)
def clearTmpFile(dataDict):
    """
    功能说明：下发查询上传升级包路径的TLV命令，用来通知阵列端清除临时文件
    """
    try:
        rest = contextUtil.getRest(dataDict)
        context = dataDict['context']
        deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
        patchType = context.get("patchType_%s"%deviceSN)
        
        if patchType == PATCH_TYPE.HOT_PATCH:
            pkgType = TLV_PACKAGE_TYPE.HOT_PATCH_PKG
        elif patchType == PATCH_TYPE.ASL_PATCH:
            pkgType = TLV_PACKAGE_TYPE.ASL_PATCH_PKG
        
        params = [] 
        param0 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_TYPE, UnsignedInt32(pkgType))
        param1 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_DIR_FILE, "")
        param2 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_SIZE, UnsignedInt32(0))
        params.extend([param0, param1, param2])
        
        log.info(dataDict, 'Execute cmd [%s] [%s]'%(unicode(restData.TlvCmd.OM_MSG_OP_GET_PACKAGE_UPLOADPATH), str(params)))
    
        #获取补丁包上传路径
        retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params)
    except:
        log.error(dataDict,"clear tmp file exception:%s" %unicode(traceback.format_exc()))     
    
