# -*- coding: UTF-8 -*-

# 补丁工具代码流程优化 added 20131112 Begin
import re
import string

#安全红线界限版本
R2C00_SECURE_VERSION = 'V100R002C00SPC010'
R2C01_SECURE_VERSION = 'V100R002C01SPC007'

# **************************************************************************** #
# 函数名称: checkSecure
# 功能说明: 判断当前版本是否为安全红线
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def checkSecure(ssh):
    isSecure = False
    sysSpcVersion = ""
    
    #获取设备系统版本号
    sysSpcVersion = getCurSystemVersion(ssh)
    if sysSpcVersion == "":
        return isSecure

    #根据设备版本号是否安全红线设备
    if bool(re.search('V100R001', sysSpcVersion, re.IGNORECASE)):
        isSecure = False
    elif bool(re.search('V100R002C00', sysSpcVersion, re.IGNORECASE)):
        if sysSpcVersion < R2C00_SECURE_VERSION:
            isSecure = False
        else:
            isSecure = True
    elif bool(re.search('V100R002C01', sysSpcVersion, re.IGNORECASE)):
        if sysSpcVersion < R2C01_SECURE_VERSION:
            isSecure = False
        else:
            isSecure = True
    elif bool(re.search('V100R005', sysSpcVersion, re.IGNORECASE)):
        isSecure = True
    else:
        isSecure = False
    #返回判断结果
    return isSecure


# **************************************************************************** #
# 函数名称: switchValidVersion
# 功能说明: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def switchValidVersion(version):
    temp = ""
    
    startIndex = version.index("V100")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V100R002C00SPC001
    else:
        endIndex = startIndex + 11  #格式：V100R005C02
    
    #提取有效的版本号信息
    temp = version[startIndex: endIndex]
    
    return temp

# *************************************************************#
# 函数名称: getCurSystemVersion
# 功能说明: 获取当前系统SPC版本号
# 其 他   :  无
# *************************************************************#
def getCurSystemVersion(ssh):
    
    #查询系统版本号
    sysSpcVersion = ""
    
    systemVerInfo = ssh.execCmd("showupgradepkginfo -t 1")
    lines = systemVerInfo.splitlines()
    # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
    if len(lines) < 7:
        return sysSpcVersion
    # 从第7行开始，取出有效信息
    field = lines[6].split()
    sysSpcVersion = switchValidVersion(field[1])
    return sysSpcVersion

# *************************************************************#
# 函数名称: getCurSystemVersion
# 功能说明: 获取当前系统SPC版本号
# 其 他   :  无
# *************************************************************#
def getCurDeviceType(ssh):
    
    #查询设备类型
    DeviceType = ""
    
    sysInfo = ssh.execCmd("showsys")
    lineList = sysInfo.splitlines()
    if re.search("System Information", sysInfo, re.IGNORECASE):
        for line in lineList:
            if line.find("Device Type") != -1:
                field = line.split()
                if len(field) == 5:
                    DeviceType = field[-1]
                break

    return DeviceType

# *************************************************************#
# 函数名称: getCurSystemVersion
# 功能说明: 获取当前系统SPC版本号
# 其 他   :  无
# *************************************************************#
def getCurHotPatchVersion(ssh, resource):

    #查询当前设备已安装热补丁
    curHotPatchVer = ""
    errMsg = ""

    hotPatchVerInfo = ssh.execCmd("showupgradepkginfo -t 3")
    #不支持热补丁，检查通过
    if re.search("not exist.|Error : Invalid argument", hotPatchVerInfo, re.IGNORECASE):
        errMsg = resource.get('2002')
        return (True, errMsg, '')

    #没有安装任何热补丁，返回空
    if re.search("command operates successfully", hotPatchVerInfo, re.IGNORECASE):
        return (True, '', '')

    #导入了热补丁包但是没有激活
    if not re.search("Running", hotPatchVerInfo, re.IGNORECASE):
        return (True, '', '')
    
    lineList = hotPatchVerInfo.splitlines()
    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        errMsg = resource.get('2003')
        return (False, errMsg, "")
    
    #正常情况下获取Running的热补丁版本
    for line in lineList:
        if re.search("A|B", line) and re.search("Running", line, re.IGNORECASE):
            field = line.split()
            if len(field) >= 2:
                curHotPatchVer = field[1]
                break
        else:
            continue 
            
    return (True, '', curHotPatchVer)

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数: dataDict
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(dataDict):

    ssh = dataDict.get("ssh")
    logger = dataDict.get("logger")
    developerPwd = ""

    #此接口只支持安全红线后的设备
    secureFlag = checkSecure(ssh)
    logger.info("Check system secure result:" + str(secureFlag))
    if secureFlag:
        #安全红线后必须输入developer密码
        try:
            developerPwd = dataDict.get("developer")
        except:
            return False
        #如果密码设置为空，则返回False
        if developerPwd == None or developerPwd == "":
            logger.error("Get developer password from ISM is None")
            return False
        
        #安全红线后设备进入developer模式
        temp = ssh.execCmd("developer")
        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")
            if re.search("Enter Password", temp1, re.IGNORECASE):
                temp2 = ssh.execCmdNoLog(developerPwd)
                if re.search("developer:", temp2, re.IGNORECASE):
                   return True
    else:
        return False
        
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

# **************************************************************************** #
# 函数名称: changeAnyModel2Cli
# 功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeAnyModel2Cli(ssh):
    
    counter = 0
    while True:
        temp = ssh.execCmd("showsys")
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer", temp, re.IGNORECASE):
                break
        #最小系统下要用login admin命令，exit会直接退出连接
        elif re.search("minisystem>", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("login admin")
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break

# *************************************************************#
# 函数名称: checkIfIPTVDevice
# 功能说明: 查看当前设备service类型是否为IPTV
# 其 他   :  无
#hw_showservicemode
#===============
# Service Mode
#---------------
#  Mode | IPTV
#===============
#
#admin:/>
# *************************************************************#
def checkIfIPTVDevice(ssh):

    processFlag = True
    ifIptvDevice = False
    
    #Cli模式下发送命令
    serviceModeTmp = ssh.execCmd("hw_showservicemode")
    if not re.search("Service Mode", serviceModeTmp, re.IGNORECASE):
        #命令获取失败
        processFlag = False
    elif re.search("IPTV", serviceModeTmp, re.IGNORECASE):
        #当前设备服务是IPTV
        ifIptvDevice = True
    else:
        pass

    return (processFlag, ifIptvDevice) 

# *************************************************************#
# 函数名称: checkIfNeedChangSlowDiskPolicy
# 功能说明: 查看当前设备是否需要修改慢盘策略
# 其 他   :  (命令的回文为如下格式，才需要更改)
#showslowdiskpolicy 
#==============================
#    Detect Slowdisk Policy
#------------------------------
#  Check Interval(s)    | 3
#  IO Asvc Time(ms)     | 100
#  Check Times          | 100
#  Slow Cycle Threshold | 50
#  Combinated Cycle     | 5
#==============================
#
#developer: admin:/>
# *************************************************************#
def checkIfNeedChangSlowDiskPolicy(ssh):
    
    processFlag = True
    ifNeedChange = True
    
    #查询慢盘策略
    slowDiskPolicyTmp = ssh.execCmd("showslowdiskpolicy")
    #命令执行失败
    if not re.search("Detect Slowdisk Policy", slowDiskPolicyTmp, re.IGNORECASE):
        processFlag = False
        ifNeedChange = False
        return (processFlag, ifNeedChange)
    
    #获取参数
    for line in slowDiskPolicyTmp.splitlines():
        field = line.split("|")
        if len(field) < 2:
            continue
        if line.find("Check Interval(s)") >= 0:
            temp0 = field[1].strip()
            #参数不为3，则修改过，不需要再修改
            if temp0 != "3":
                ifNeedChange = False
                return (processFlag, ifNeedChange)
        elif line.find("IO Asvc Time(ms)") >= 0:
            temp1 = field[1].strip()
            #参数不为100，则修改过，不需要再修改
            if temp1 != "100":
                ifNeedChange = False
                return (processFlag, ifNeedChange)
        elif line.find("Check Times") >= 0:
            temp2 = field[1].strip()
            #参数不为100，则修改过，不需要再修改
            if temp2 != "100":
                ifNeedChange = False
                return (processFlag, ifNeedChange)
        elif line.find("Slow Cycle Threshold") >= 0:
            temp3 = field[1].strip()
            #参数不为100，则修改过，不需要再修改
            if temp3 != "50":
                ifNeedChange = False
                return (processFlag, ifNeedChange)
        elif line.find("Combinated Cycle") >= 0:
            temp4 = field[1].strip()
            #参数不为100，则修改过，不需要再修改
            if temp4 != "5":
                ifNeedChange = False
                return (processFlag, ifNeedChange)
    
    #参数全部满足要求，则需要修改
    ifNeedChange = True
    return (processFlag, ifNeedChange)
# 补丁工具代码流程优化 added 20131112 End
