# -*- coding: UTF-8 -*-

import re
import string
import os
from Properties import *
import types

ERRORCODE_ZH_FILE_NAME = r"..{0}errCode{0}errorInfo_zh.properties".format(os.sep)
ERRORCODE_EN_FILE_NAME = r"..{0}errCode{0}errorInfo_en.properties".format(os.sep)

# *************************************************************#
# 函数名称: execute
# 功能说明: 解析errCode文件
# 其 他   :  无
# *************************************************************#
def execute(dataDict):
    
    lang = dataDict.get("lang")
    errCodeId = str(dataDict.get('errorId'))
    inputParamList = dataDict.get('params')

    errMsgDesc = ""
    curPath = os.path.split(os.path.realpath(__file__))[0]
    
    #根据语言环境解析文件
    if lang == 'zh':
        fileName = curPath + os.sep + ERRORCODE_ZH_FILE_NAME
    else:
        fileName = curPath + os.sep + ERRORCODE_EN_FILE_NAME
    
    #调用Properties类，实现描述解析 
    p = Properties(fileName)
    #设置参数分隔符
    p.setParamPartStr("#???")
    
    #设置传入参数
    getProParamList = [errCodeId]
    if type(inputParamList) is types.ListType and inputParamList != {}:
        getProParamList.extend(inputParamList)

    errMsgDesc = p.getProperties(getProParamList)
 
    #没有获取有效描述，设定默认显示信息
    if errMsgDesc == "":
        if lang == "zh":
            errMsgDesc = u"操作失败，错误码ID：" + str(errCodeId)
        else:
            errMsgDesc = "Operation error, errCodeId:" + str(errCodeId)

    return errMsgDesc
