# -*- coding: UTF-8 -*-

import re
import string
import getPatchInXml
import resourceParse
import common

# **************************************************************************** #
# 函数名称: IsSystemVersionSupport
# 功能说明: 判断当前系统版本号是否支持
# 输入参数: ssh
# 返 回 值: True or False
# **************************************************************************** # 
def IsSystemVersionSupport(ssh):
    
    return common.checkSecure(ssh)

# *************************************************************#
# 函数名称: execute
# 功能说明: 解析热补丁包所在路径，返回字典：热补丁版本号+对应的文件名(入口函数)
# 其 他   :  无
# *************************************************************#
def execute(dataDict):

    ssh = dataDict.get("ssh")
    lang = dataDict.get("lang")
    logger = dataDict.get("logger")
    
    #解析resource文件并保存
    resource = resourceParse.execute(lang)
    dataDict["resource"] = resource
    
    DeviceType = ""
    searchDeviceType = ""
    systemVersion = ""
    curHotPatchVer = ""
    
    #返回信息设定
    curSystemInfo = ""
    hotPatchCheckInfo = ""
    
    #检查返回的详细信息
    checkFlag = True
    errMsg = ""
    checkDetails = ()
    IfExistHotPatch = False
    IfNeedUpgrade = False
    newHotPatchVerCmp = ""
    newHotPatchVerRet = ""
    newhotPatchInfo = ""
    
    # 补丁工具代码流程优化 modified 20131112 Begin
    #查询设备类型
    DeviceType = common.getCurDeviceType(ssh)
    #查询设备类型失败
    if DeviceType == "":
        checkFlag = False
        errMsg = resource.get('2000')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)
    
    logger.info("Get the device type succeed:" + str(DeviceType))

    #查询系统版本号
    systemVersion = common.getCurSystemVersion(ssh)
    #查询设备类型失败
    if systemVersion == "":
        checkFlag = False
        errMsg = resource.get('2001')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)
    
    logger.info("Get the system SPC version succeed:" + str(systemVersion))
    
    #判断版本是否支持
    if not IsSystemVersionSupport(ssh):
        logger.info("Current system version is too low:" + str(systemVersion))
        checkFlag = False
        errMsg = resource.get('2009')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)

    #IPTV设备需要获取developer密码
    developerPwd = dataDict.get("developer")
    #developer密码为空，需要判断是否为IPTV设备
    if developerPwd == None or developerPwd == "":
        #S3900的IPTV设备,版本为"V100R005C00SPC700", "V100R002C00SPCh00"，安装补丁后，需要设定IPTV服务的慢盘参数
        if DeviceType in ["S3900-M200", "S3900-M300", "S5500T"] and systemVersion in ["V100R005C00SPC700", "V100R002C00SPCh00"]:
        
            #Cli模式下判断是否为IPTV设备
            iRet = common.checkIfIPTVDevice(ssh)
            flag = iRet[0]
            ifIptvDevice = iRet[1]
            #获取信息失败，返回
            if not flag:
                checkFlag = False
                errMsg = resource.get("2015")
                checkDetails = (IfNeedUpgrade, '', '')
                return (checkFlag, errMsg, checkDetails)
    
            #IPTV设备需要developer密码，返回错误
            if ifIptvDevice:
                logger.error("Current system is IPTV Service, need developer password.")
                checkFlag = False
                errMsg = resource.get('2018')
                checkDetails = (IfNeedUpgrade, '', '')
                return (checkFlag, errMsg, checkDetails)

    #查询设备是否对应热补丁
    iRet = getPatchInXml.checkPatchInfo(DeviceType, systemVersion, lang, logger)
    IfExistHotPatch = iRet[0]
    logger.info("Whether current version releases hotpatch:" + str(IfExistHotPatch))
    #当前设备型号和版本不存在发布的热补丁，检查通过
    if IfExistHotPatch == False:
        logger.info("Current version does not release hotpatch, check pass!")
        checkDetails = (False, "", "")
        return (True, '', checkDetails)

    newHotPatchVerRet = iRet[1]
    newhotPatchInfo = iRet[2]

    #查询设备当前已安装热补丁版本号
    iRet = common.getCurHotPatchVersion(ssh, resource)
    errMsg = iRet[1]
    #获取补丁失败
    if not iRet[0]:
        checkDetails = (False, "", "")
        return (False, errMsg, checkDetails)
    #当前版本不支持热补丁，直接返回
    if errMsg == resource.get('2002'):
        checkDetails = (False, "", "")
        return (True, errMsg, checkDetails)
    
    #获取热补丁版本号
    curHotPatchVer = iRet[2]

    #判断当前已安装的补丁是否为最新补丁
    curHotPatchVerCmp = curHotPatchVer[-6:]
    newHotPatchVerCmp = newHotPatchVerRet[-6:]
    logger.info("Current system compare hotpatch version:" + str(curHotPatchVerCmp))
    logger.info("Current released compare hotpatch version:" + str(newHotPatchVerCmp))
    
    #当前系统未安装任何补丁
    if curHotPatchVerCmp == "":
        checkFlag = True
        IfNeedUpgrade = True
        logger.info("Current system does not been hotpatched, need install the hotpatch!")
        checkDetails = (IfNeedUpgrade, newHotPatchVerRet, newhotPatchInfo)
    #当前系统安装非最新的热补丁
    elif curHotPatchVerCmp < newHotPatchVerCmp:
        checkFlag = True
        IfNeedUpgrade = True
        logger.info("Current system hotpatch version is too low, need install the newest hotpatch!")
        checkDetails = (IfNeedUpgrade, newHotPatchVerRet, newhotPatchInfo)
    #当前设备已安装最新热补丁
    elif curHotPatchVerCmp == newHotPatchVerCmp:
        checkFlag = True
        logger.info("Current system hotpatch version is the newest, check pass!")
        checkDetails = (IfNeedUpgrade, '', '')
    #当前工具的配置文件非最新，检查通过
    elif curHotPatchVerCmp > newHotPatchVerCmp:
        checkFlag = True
        logger.info("Current system hotpatch version is larger then the data configured in the xml, check error!")
        checkDetails = (IfNeedUpgrade, '', '')
    else:
        checkFlag = False
        errMsg = resource.get('2005')    
        checkDetails = (IfNeedUpgrade, '', '')

    #检查结果返回
    return (checkFlag, errMsg, checkDetails)
