# -*- coding: UTF-8 -*-

import re
import string
import os

RESOURCE_ZH_FILE_NAME = r"..{0}res{0}resource_zh.properties".format(os.sep)
RESOURCE_EN_FILE_NAME = r"..{0}res{0}resource_en.properties".format(os.sep)

# *************************************************************#
# 函数名称: execute
# 功能说明: 解析resource文件
# 其 他   :  无
# *************************************************************#
def execute(lang):
    resource = {}
    key = ""
    value = ""
    curPath = os.path.split(os.path.realpath(__file__))[0]
    
    #根据语言环境解析文件
    if lang == 'zh':
        fileName = curPath + os.sep + RESOURCE_ZH_FILE_NAME
    else:
        fileName = curPath + os.sep + RESOURCE_EN_FILE_NAME
    
    file = open(fileName)
    resourceInfo = file.read().decode("utf-8")
    #关闭文件
    file.close()
    lineList = resourceInfo.splitlines()
    #读取解析文件
    for line in lineList:
        if re.search("=", line, re.IGNORECASE):
            field = line.split("=")
            if len(field) == 2:
                key = field[0]
                value = field[1]
                resource[key] = value

    return resource
