# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.business.checkitems.check_item_daemon_process import (
    CheckDeamonProcess,
)
from cbb.frame.cli.execute_on_all_controllers import ExeOnAllCtrlContext
from cbb.frame.cli.execute_on_all_controllers import ResultType
from com.huawei.ism.tool.obase.exception import ToolException
from resource.resource import MESSAGES_DICT


def execute(data_dict):
    return pre_check(data_dict)


def pre_check(data_dict):
    # 升级检查
    return dispose_resource(data_dict)


def dispose_resource(data_dict):
    cli = contextUtil.getCliCommon(data_dict)
    logger = contextUtil.getLogger(data_dict)
    lang = contextUtil.getLang(data_dict)
    exe_context = ExeOnAllCtrlContext(data_dict)
    check_deamonprocess = CheckDeamonProcess(exe_context, logger, lang, cli)
    try:
        result_type, err_mag = check_deamonprocess.execute_check()
        err_mag = err_mag if err_mag not in MESSAGES_DICT \
            else baseUtil.getPyResource(lang, err_mag, "", resource=MESSAGES_DICT)
        return (get_result(result_type), err_mag, "".join(check_deamonprocess.all_ret_list))
    except (ToolException, Exception) as exception:
        logger.error(str(exception))
        if "PwdCLIOverrunException" in str(exception):
            check_deamonprocess.all_ret_list.append(exception.getErrorId())
            return (
                "NOCHECK",
                baseUtil.getPyResource(lang, "login.clis.overrun.info", "", resource=MESSAGES_DICT),
                "".join(check_deamonprocess.all_ret_list)
            )
        return (
            "NOCHECK",
            baseUtil.getPyResource(lang, "query.result.abnormal", "", resource=MESSAGES_DICT),
            "".join(check_deamonprocess.all_ret_list)
        )


def get_result(result_type):
    trans_dict = {
        ResultType.SUCCESS: True,
        ResultType.FAILED: False,
        ResultType.NOT_FINISHED: "NOCHECK",
        ResultType.NOT_SUPPORT: "NOSUPPORT",
        ResultType.WARNING: "WARNING",
    }
    return trans_dict.get(result_type)
