#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from cbb.frame.cli import cliUtil
from cbb.frame.cli.execute_on_all_controllers import (
    ExecuteOnAllControllers,
    ResultType,
    FuncResult,
    ExeOnAllCtrlContext
)


# 执行入口
def execute(dataDict):
    dataDict['checkType'] = "POSTCHECK"
    fdsa_post_check(dataDict)
    return True, "Tunefs Check pass", None


def fdsa_post_check(dataDict):
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    exe_context = ExeOnAllCtrlContext(dataDict)
    cli = exe_context.dev_info.cli
    lang = exe_context.lang

    flag, cur_version, cur_patch = cliUtil.getSystemVersion(cli, lang)
    if not flag:
        logger.error("Get system Version failed")
        return
    cur_patch = cur_patch[11:]
    logger.info("Current device version:%s" % cur_version)
    logger.info("Current device patch version:%s" % cur_patch)

    if (cur_version != "V500R007C61") and (cur_version != "V300R006C61"):
        logger.info("Current device is not target version")
        return

    if cur_patch < "SPH060" or cur_patch >= "SPH066":
        logger.info("Current device is not problem patch version")
        return

    set_fdsa_sysdisk_switch(exe_context)
    logger.info("Set fdsa sysdisk switch done")

    return


@ExecuteOnAllControllers
def set_fdsa_sysdisk_switch(dataDict):
    cli = dataDict.dev_info.cli
    lang = dataDict.lang
    cmd = "set_fdsa_sysdisk_switch.sh on"
    cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
    return FuncResult(ResultType.SUCCESS, "", "")