# -*- coding: UTF-8 -*-
from cbb.business.checkitems.ad_domian_connectivity_check import (
    AdDomainConnCheck,
)
from cbb.frame.checkitem.context_adapter import PatchContext
from cbb.frame.checkitem.base_dsl_check import CheckStatus
from cbb.frame.ruleConfig.common import getMsg
from cbb.frame.context import contextUtil

from common.baseFactory import log


def execute(context):
    """
    AD连通性检查
    :param context:
    :return:
    """
    patch_context = PatchContext(context)
    lang = contextUtil.getLang(context)
    check_obj = AdDomainConnCheck(patch_context.get_context())
    status, err_msg = check_obj.check()
    if status != CheckStatus.PASS and status != CheckStatus.NO_SUPPORT:
        err_sug = getMsg(lang, "ad.domain.conn.check.fail.sugg")
        err_msg = u"{}\n{}".format(err_msg, err_sug)
    status, err_msg = patch_context.get_result(status, err_msg)
    cli_ret = check_obj.get_origin_info()
    log.info(context, u"res: status:{}, err_msg:{}, cli_ret:{}".format(
        status, err_msg, cli_ret))
    return status, err_msg, cli_ret
