#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
from checkitems.dev_free_memory import DevFreeMemory
from checkitems.check_controller_status import ControllerStatus

# 2021-08-30 新增 只落入补丁评估，不落补丁安装前检查。
# 满足前提条件（控制器都是normal（已有的检查项sys isalldoublectrl）且
# 空闲内存低于350M时），则执行 前端链路配置正确性检查、硬盘单链路检查、
# 异构LUN单链路状态检查，具体的检查方式参考升级工具的，不满足条件则直接pass。

# 空闲内存低于350M时
FREE_MEM_NUM = 350


def link_pre_check(data_dict):
    """
    在检查前，先检查是否为单控和空闲内存大于350
    如果是，则无需进行检查

    :param context:
    :return:
    """
    free_memory = DevFreeMemory(data_dict)
    flag, err_msg, cli_ret = free_memory.check_free_memory(FREE_MEM_NUM)
    if flag:
        return True, err_msg, cli_ret

    controller_status = ControllerStatus(data_dict)
    flag, msg, ret = controller_status.get_result()
    if not flag:
        return True, msg, ret
    return False, msg, ret
