# -*- coding: UTF-8 -*-
"""
@desc: 内存资源检查
@date: 2021.2.4
"""


from cbb.business.checkitems.software_memory_leakage_check import (
    MemoryLeakageCheck,
)
from cbb.frame.checkitem.context_adapter import PatchContext
from cbb.frame.checkitem.base_dsl_check import CheckStatus

from common.baseFactory import log


def execute(context):
    """
    内存资源检查
    :param context:
    :return:
    """
    dev = context.get('dev')
    product_version = str(dev.getProductVersion())
    product_mode = str(dev.getDeviceType())
    patch_context = PatchContext(context)
    temp_context = patch_context.get_context()
    temp_context["product_version"] = product_version
    temp_context["product_mode"] = product_mode
    log.info(context, u"memory leakage check,version:{}, mode:{}".format(
        product_version, product_mode))
    item_check = MemoryLeakageCheck(temp_context)
    flag, msg = item_check.check()
    log.info(context, u"memory leakage check:flag:{},msg:{}".format(
        flag, msg))

    # 明确不通过才不通过，即使命令执行失败都通过。
    if flag == CheckStatus.NOTPASS:
        return False, msg, item_check.get_origin_info()

    return True, '', item_check.get_origin_info()
