# -*- coding: UTF-8 -*-
from cbb.business.checkitems.net_log_on_ex_enable_check import (
    NetLogEnableCheck,
)

from cbb.frame.checkitem.context_adapter import PatchContext
from cbb.frame.ruleConfig.common import getMsg
from cbb.frame.context import contextUtil
from cbb.frame.checkitem.base_dsl_check import CheckStatus

from common.baseFactory import log


def execute(context):
    """
    NetLogonEX开关检查
    :param cli:
    :return:
    """
    dev = context.get('dev')
    product_version = str(dev.getProductVersion())
    product_mode = str(dev.getDeviceType())
    patch_context = PatchContext(context)
    lang = contextUtil.getLang(context)
    temp_context = patch_context.get_context()
    temp_context["mem_version"] = product_version
    temp_context["product_mode"] = product_mode
    log.info(context, u"netlog ex enable,version:{}, mode:{}".format(
        product_version, product_mode))
    net_log_check = NetLogEnableCheck(temp_context)
    flag, msg = net_log_check.check()
    log.info(context, u"netlog ex enable,vstore:{},flag:{},msg:{}".format(
        net_log_check.error_list, flag, msg))
    if flag == CheckStatus.NOCHECK:
        return (
            False,
            getMsg(lang, "netlog.ex.enable.query.info.fail"),
            net_log_check.get_origin_info()
        )
    flag, err_msg = patch_context.get_result(flag, msg)
    if flag is not True:
        err_msg = getMsg(lang, "netlog.ex.enable.not.pass.patch",
                         ", ".join(net_log_check.error_list))
        return False, err_msg, net_log_check.get_origin_info()
    return True, '', net_log_check.get_origin_info()
