# -*- coding: UTF-8 -*-

from common.baseFactory import log
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil


def execute(context):
    """

    :param context:
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    logger = contextUtil.getLogger(context)
    target_patch_version = context.get("pkgVersion")
    dev = context.get("dev")
    product_version = dev.getProductVersion()
    flag, product_model, err_msg, cli_ret = cliUtil.get_product_model_with_ret(cli, lang)
    if flag is not True:
        # 可能是OEM后的版本，查不到Product Mode
        product_model = str(dev.getDeviceType())
        cli_ret = "Product Model:{}, \nProduct Version:{}".format(product_model, product_version)
        logger.info("query product model fail use info in memory")

    if all(
        [
            product_version == "V300R002C10SPC100",
            product_model != "Dorado NAS",
            target_patch_version == "V300R002C10SPH156",
        ]
    ):
        return False, cliUtil.getMsg(lang, "patch.eval.doardo.nas.target.patch.check"), cli_ret

    return True, "", cli_ret
