# -*- coding: UTF-8 -*-
import os
import defusedxml.ElementTree as ET


class ResourceXmlUtil:
    @staticmethod
    def parse():
        """
        @summary: 解析xml文件
        @param filePath: xml文件路径
        @return: 解析后的xml文件信息（一个嵌套的字典)
        all_resource_dict={"getHost":{
                            "selector":"commonSelector",
                            "restImpl":{"className":"", },
                            "tlvImpl":{"className":"", "adapter":""}}}
        """
        script_path = os.path.split(os.path.realpath(__file__))[0]
        config_file = script_path + os.sep + "resources.xml"
        xml_element_tree = ET.parse(config_file)
        resource_elements = xml_element_tree.getiterator("resource")
        all_resource_dict = dict()
        for resource_element in resource_elements:
            resource_name = resource_element.attrib.get("id", "").strip()
            resourceSelector = resource_element.attrib.get(
                "selector", ""
            ).strip()
            resource_dict = dict(selector=resourceSelector)
            impl_elements = resource_element.getchildren()
            for impl_element in impl_elements:
                impl_type = impl_element.tag
                impl_class = impl_element.attrib.get("className")
                impl_adapter = impl_element.attrib.get("adapter")
                impl_bean = impl_element.attrib.get("bean")
                resource_dict[impl_type] = dict(
                    className=impl_class, adapter=impl_adapter, bean=impl_bean
                )
            all_resource_dict[resource_name] = resource_dict
        return all_resource_dict
