# -*- coding: UTF-8 -*-
from hotpatch import SysResourcePostCheck
from hotpatch import HdsVersionCheck
from common.constant import PATCH_TYPE
from common.baseFactory import log, threadUp, finishProcess
totalRemainTime = 13

def execute(dataDict):
    try:
        threadUp(dataDict, "postcheck", totalRemainTime)
        deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
        context = dataDict.get("context")
        patchType = context.get("patchType_%s"%deviceSN)
        log.info(dataDict,"patchType:==============="+patchType)

        checkFlag = True
        checkMsg = ""
        if patchType == PATCH_TYPE.HOT_PATCH:
            processRet = SysResourcePostCheck.execute(dataDict)
            checkMsg += processRet[1] + "\n"
            if not processRet[0]:
                checkFlag = False
            processRet = HdsVersionCheck.execute(dataDict)
            checkMsg += processRet[1] + "\n"
            if not processRet[0]:
                checkFlag = False

        return (checkFlag, checkMsg, None)
    finally:
        finishProcess(dataDict, "postcheck")