# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

from common import resourceParse
from common import checkUtils


CMD_DEFAULT_TIMEOUT = 60

def execute(dataDict):

    
    ##执行升级前检查
    return preCheck(dataDict)
    
    

def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    logger = dataDict.get("logger")
    recNum = recs.size()
    
    upgradeErrMsg = ''
    itemState = True
    for index in range(0, recNum):
        rec = recs.get(index)
        nodeId = rec.getParamStrValue(0)
        result = rec.getParamStrValue(1)
        logger.info("SysResourcePostCheck result:" + unicode(result))
        if (result == "TimeOut"):
            #执行超时
            itemState = False
            errorKey = "SysResourcePostCheck.timeout"
        else:
            cpuUsage = int(result.split(",")[0])
            memoryRemain = int(result.split(",")[1])
            if (cpuUsage <= 60) and (memoryRemain >= 100):
                #执行成功
                errorKey = "SysResourcePostCheck.pass"    
            else:
                #执行出错
                itemState = False
                errorKey = "SysResourcePostCheck.notpass"
        upgradeErrMsg += nodeId + '--' + resource.get(errorKey) + '\n'
    if not upgradeErrMsg:
        itemState = False
        upgradeErrMsg = resource.get("SysResourcePostCheck.error")
    return (itemState, upgradeErrMsg, None)

def preCheck(dataDict):
    recs = checkUtils.executeCheck(dataDict, "upd sysresourcecheck", 2)
    return disposeRecs(recs, dataDict)
