# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus
from common.baseFactory import executeCheck
from common import resourceParse 
from common.baseFactory import log

def execute(dataDict):
    ##执行升级前检查
    return preCheck(dataDict)

def disposeRecs(recs, dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    recNum = recs.size()
    upgradeErrMsg = ''
    itemState = True
    for index in range(0, recNum):
        rec = recs.get(index)
        nodeId = rec.getParamStrValue(0)
        result = rec.getParamStrValue(1)
        log.info(dataDict,"ISDoubleCtrlCheck result:" + result)
        if result == "True":
            #执行成功
            errorKey = "ISDoubleCtrlCheck.pass"
        elif result == "False":
            #执行失败
            itemState = False
            errorKey = "ISDoubleCtrlCheck.notpass"
        elif result == "TimeOut":
            #执行超时
            itemState = False
            errorKey = "ISDoubleCtrlCheck.timeout"
        else:
            #执行出错
            itemState = False
            errorKey = "ISDoubleCtrlCheck.error"
        upgradeErrMsg += nodeId + '--' + resource.get(errorKey)+ '\n'
    if not upgradeErrMsg:
        itemState = False
        upgradeErrMsg = resource.get("ISDoubleCtrlCheck.error")
    return (itemState, upgradeErrMsg, None)

def preCheck(dataDict):
        recs = executeCheck(dataDict, "sys isalldoublectrl", 2)       
        return disposeRecs(recs,dataDict)

