# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from common import constant
from common.baseFactory import log

CMD_DEFAULT_TIMEOUT = 60


"""
    执行升级前后检查
"""
def executeCheck(dataDict, command, locationId):
        tlvCon = dataDict["tlv"]
        
        msgParam0 = Param(0, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam1 = Param(1, ParamType.STRING, "")
        msgParam2 = Param(2, ParamType.UNSIGN_INT, UnsignedInt32(0))
        msgParam3 = Param(3, ParamType.STRING, "")
        msgParam4 = Param(4, ParamType.STRING, "")
        msgParam5 = Param(5, ParamType.STRING, "")
        msgParam6 = Param(6, ParamType.STRING, "")
        msgParam7 = Param(7, ParamType.STRING, "")
        msgParam8 = Param(8, ParamType.STRING, "")
        msgParam9 = Param(9, ParamType.STRING, "")
        msgParam12 = Param(12, ParamType.STRING, command)
        msgParam13 = Param(13, ParamType.UNSIGN_INT, UnsignedInt32(locationId))
        params = TLVUtils.paramList(msgParam0, msgParam1, msgParam2, msgParam3, msgParam4, msgParam5, msgParam6, msgParam7, msgParam8, msgParam9,msgParam12,msgParam13)
        recs = tlvCon.getBatchWithRetry(
                constant.TLV_CMD.EXC_UPD, params,
                CMD_DEFAULT_TIMEOUT, constant.AFTER_UPGRADE_RETRYTIMES,
                constant.AFTER_UPGRADE_INTERVAL)
        log.info(dataDict,
                 'TLV cmd [%d] send[%s] receive[%s]'
                 % (constant.TLV_CMD.EXC_UPD, str(params), str(recs)))
        return recs



