# -*- coding: UTF-8 -*-
from common.baseFactory import *
from common import resourceParse
from common.baseFactory import log
from com.huawei.ism.tool.devicepatch.utils import DevicePatchUtil
from common.constant import FAN_CTRL_MODULE
from com.huawei.ism.tool.devicepatch.remote.entity import TaskInfo

DEVICELIST = ["18500 V3", "18800 V3"]
CHECKMAP = {"V300R003C00SPC100" : "V300R003C00SPH103",
            "V300R003C10SPC100" : "V300R003C10SPH108",}
CRITICALDATA = "2016-11-30"

def execute(dataDict):
    
    ##执行升级前检查,检查是否（6U两控+2个风扇盒的硬件形态）风扇盒存在固有bug问题
    return disposeRecs(dataDict)
    
def disposeRecs(dataDict):
    lang = dataDict['lang']
    resource = resourceParse.execute(lang)
    devNode = dataDict['dev']
    context = dataDict.get("context")
    
    upgradeErrMsg = ''
    itemState = True
    
    deviceType = devNode.getDeviceType()
    log.info(dataDict, "[FanCtrlModuleCheck] Device type: %s." % str(deviceType))
    if str(deviceType) not in DEVICELIST:
        return (itemState, upgradeErrMsg, None)
    
    deviceVersion = getCurSystemVersion(dataDict)[1]
    checkPatchVer = CHECKMAP.get(deviceVersion)
    log.info(dataDict, "[FanCtrlModuleCheck] Current version: %s, match patch: %s." % (str(deviceVersion), str(checkPatchVer)))
    if not checkPatchVer:
        return (itemState, upgradeErrMsg, None)
    
    deviceSN = devNode.getDeviceSerialNumber()
    pkgVersion = context.get("hotPatchPKGVersion_%s" % deviceSN)
    log.info(dataDict, "[FanCtrlModuleCheck] Package version: %s." % str(pkgVersion))
    curPatchVersion = context.get("curPatchVersion_%s"%deviceSN)
    log.info(dataDict, "[FanCtrlModuleCheck] curPatchVersion: %s." % str(curPatchVersion))
    
    if pkgVersion < checkPatchVer:
        return (itemState, upgradeErrMsg, None)
    if curPatchVersion >= checkPatchVer:
        return (itemState, upgradeErrMsg, None)
    
    recs = getFanCtrlModuleRecords(dataDict)
    recNum = 0
    for rec in recs:
        elabelStr = rec.getParamStrValue(FAN_CTRL_MODULE.fanCtrlModule['elabel'])
        elabelDict = getElabelDict(elabelStr)
        if elabelDict['Manufactured'] < CRITICALDATA:
            recNum += 1
    log.info(dataDict, "[FanCtrlModuleCheck] Number of FanCtrlModule produced before 2016-11-30: %s." % str(recNum))
    if recNum > 0:
        isremote = TaskInfo.REMOTE_TASK.isRemoteTask()
        log.info(
            dataDict,
            "[FanCtrlModuleCheck] Current task is remote:%s" % str(isremote))
        if isremote:
            upgradeErrMsg = resource.get("FanCtrlModuleCheck.remote.notpass")
            return (False, upgradeErrMsg, None)

        choose = DevicePatchUtil.showWarnOptConfimDialog()
        ##rec是用户选择的结果，True选择的“是”，False选择的是“否”
        log.info(dataDict, "[FanCtrlModuleCheck] User choose: %s." % str(choose))
        if not choose:
            itemState = False
            upgradeErrMsg += resource.get("FanCtrlModuleCheck.notpass")

    return (itemState, upgradeErrMsg, None)
    
    

