# -*- coding: UTF-8 -*-

import re
import string
from common import getPatchInXml
from common import resourceParse
from common import baseFactory
from common.baseFactory import log

# *************************************************************#
# 函数名称: execute
# 功能说明: 解析热补丁包所在路径，返回字典：热补丁版本号+对应的文件名(入口函数)
# 其 他   :  无
# *************************************************************#
def execute(dataDict):
    #初始化全局字典
    context = dataDict.get('context')
    deviceSN = str(dataDict.get('dev').getDeviceSerialNumber())
    context['patchType_%s'%deviceSN] = ''

    lang = dataDict.get("lang")
    
    #解析resource文件并保存
    resource = resourceParse.execute(lang)
    dataDict["resource"] = resource
    
    
    
    #检查返回的详细信息
    checkFlag = True
    errMsg = ""
    checkDetails = ()
    IfExistHotPatch = False
    IfNeedUpgrade = False
    newHotPatchVerCmp = ""
    newHotPatchVerRet = ""
    newhotPatchInfo = ""
    
    #查询设备类型
    checkFlag,productModel = baseFactory.getCurProductModel(dataDict)
    #查询设备类型失败
    if not checkFlag:
        errMsg = resource.get('upload.getProductModel')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)
    
    log.info(dataDict,"Get the device type succeed:" + str(productModel))

    #查询系统版本号
    checkFlag,systemVersion = baseFactory.getCurSystemVersion(dataDict)
    #查询设备类型失败
    if not checkFlag:
        errMsg = resource.get('upload.getSystemVersion')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)
    
    log.info(dataDict,"Get the system SPC version succeed:" + str(systemVersion))

    #查询设备是否对应热补丁
    iRet = getPatchInXml.checkPatchInfo(productModel, systemVersion, lang, dataDict)
    IfExistHotPatch = iRet[0]
    log.info(dataDict,"Whether current version releases hotpatch:" + str(IfExistHotPatch))
    #当前设备型号和版本不存在发布的热补丁，检查通过
    if IfExistHotPatch == False:
        log.info(dataDict,"Current version does not release hotpatch, check pass!")
        checkDetails = (False, "", "")
        return (True, '', checkDetails)

    newHotPatchVerRet = iRet[1]
    newhotPatchInfo = iRet[2]

    #查询设备当前已安装热补丁版本号
    checkFlag,curHotPatchVer = baseFactory.getHotPatchCurVersion(dataDict)
    #获取补丁失败
    if not checkFlag:
        errMsg = resource.get('upload.getCurHotpacthVersion')
        checkDetails = (False, "", "")
        return (checkFlag, errMsg, checkDetails)

    #判断当前已安装的补丁是否为最新补丁
    curHotPatchVerCmp = curHotPatchVer[-6:]
    newHotPatchVerCmp = newHotPatchVerRet[-6:]
    log.info(dataDict,"Current system compare hotpatch version:" + str(curHotPatchVerCmp))
    log.info(dataDict,"Current released compare hotpatch version:" + str(newHotPatchVerCmp))
    
    #当前系统未安装任何补丁
    if curHotPatchVerCmp == "":
        checkFlag = True
        IfNeedUpgrade = True
        log.info(dataDict,"Current system does not been hotpatched, need install the hotpatch!")
        checkDetails = (IfNeedUpgrade, newHotPatchVerRet, newhotPatchInfo)
    #当前系统安装非最新的热补丁
    elif curHotPatchVerCmp < newHotPatchVerCmp:
        checkFlag = True
        IfNeedUpgrade = True
        log.info(dataDict,"Current system hotpatch version is too low, need install the newest hotpatch!")
        checkDetails = (IfNeedUpgrade, newHotPatchVerRet, newhotPatchInfo)
    #当前设备已安装最新热补丁
    elif curHotPatchVerCmp == newHotPatchVerCmp:
        checkFlag = True
        log.info(dataDict,"Current system hotpatch version is the newest, check pass!")
        checkDetails = (IfNeedUpgrade, '', '')
    #当前工具的配置文件非最新，检查通过
    elif curHotPatchVerCmp > newHotPatchVerCmp:
        checkFlag = True
        log.info(dataDict,"Current system hotpatch version is larger then the data configured in the xml, check error!")
        checkDetails = (IfNeedUpgrade, '', '')
    else:
        checkFlag = False
        errMsg = resource.get('upload.hotPatchVersionCompare')    
        checkDetails = (IfNeedUpgrade, '', '')

    #检查结果返回
    log.info(dataDict,'Hot patch check succeed !')
    return (checkFlag, errMsg, checkDetails)
