# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
"""
@version: Toolkit 22.0.0
@time: 2022/04/18
@file: check_image_partition_raid_state.py
@function: 系统分区软raid检查
@modify:
"""

from com.huawei.ism.tool.obase.utils import ManualConfigItemMgr
from common import resourceParse
from common.constant import PATCH_TYPE
from common import upload
from hotpatch import PatchCheck

from cbb.frame.context import contextUtil
from service.func_utils import check_system_type_version, get_auth_package_path

SKIP_SOFT_RAID_CHECK_FOR_SYSTEM_PARTITION = "global.soft.raid.check.for.system.partitions"


def execute(data_dict):
    return CheckImagePartitionRaidState(data_dict).execute_check()


class CheckImagePartitionRaidState:
    def __init__(self, data_dict):
        self.all_ret_list = list()
        self.exec_context = data_dict
        self.logger = contextUtil.getLogger(data_dict)
        self.lang = contextUtil.getLang(data_dict)
        self.cli = contextUtil.getCli(data_dict)
        self.dev = data_dict.get("dev")
        self.all_cli_ret = []

    def execute_check(self):
        # ignoreItem.txt中系统分区软raid检查是否为忽略，如果忽略默认检查通过。
        if ManualConfigItemMgr.getInstance().expected(SKIP_SOFT_RAID_CHECK_FOR_SYSTEM_PARTITION, "yes"):
            self.logger.info("the Soft raid check for system partitions is restricted check items.")
            return True, "", self.get_all_ret()

        self.logger.info("the Soft raid check for system partitions start.")
        # 获取系统版本 , 版本判断是否为风险版本
        if not self.is_risk_version_type():
            self.logger.info("The device model version is not in the risky version.")
            return True, "", self.get_all_ret()
        # 设置假包路径到上下文
        self.exec_context["packagePath"] = get_auth_package_path()
        context = self.exec_context['context']
        context["patchType_{}".format(str(self.dev.getDeviceSerialNumber()))] = PATCH_TYPE.HOT_PATCH

        # 工具上传补丁包到阵列 导包失败，则检查不通过，否则继续检查。
        flag, err_msg = upload.execute(self.exec_context)
        self.all_cli_ret.append("Upload the verification patch package to storage")
        if not flag:
            return False, err_msg, self.get_all_ret()
        # 工具发送消息到阵列进行补丁包检查, 如果步骤3提示错误码sysdiskerror，则检查不通过。
        self.logger.info("Start verification package check.")
        resource = resourceParse.execute(self.lang)
        flag, err_msg, cli_ret = PatchCheck.execute(self.exec_context)
        if not flag and resource.get("HotPatchCheck.notpass.sysdiskerror") in err_msg:
            return False, err_msg, self.get_all_ret()

        return True, "", self.get_all_ret()

    def get_all_ret(self):
        return "\n".join(self.all_cli_ret)

    def is_risk_version_type(self):
        product_model = str(self.dev.getDeviceType())
        product_version = str(self.dev.getProductVersion())
        self.logger.info("productModel is: {}, productVersion:{}".format(product_model, product_version))
        self.all_cli_ret.append("productModel is: {}, productVersion:{}".format(product_model, product_version))
        return check_system_type_version(product_model, product_version)
