/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.List;

public class CallbackPackageSnMappingUtils {
    private static final String UPLOAD_PATH = "upload";
    private static final String MAPPING_FILE_NAME_PREFIX = "packageSnMapping_";
    private static final String MAPPING_FILE_NAME_SUFFIX = ".data";

    public static boolean recordToolPackageSnMapping(String packageType, List<DevNode> devices, String packageName) {
        String deviceSNs = CallbackPackageSnMappingUtils.spliceDeviceSns(devices);
        if (null == deviceSNs) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("the list of devices is null!");
            return false;
        }
        if (StringUtils.isNULLStr(packageType)) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("the packageType is empty!");
            return false;
        }
        return CallbackPackageSnMappingUtils.doRecord2PersistFile(packageType, deviceSNs, packageName);
    }

    public static boolean recordToolPackageSnMapping(String packageType, String deviceSns, String packageName) {
        if (StringUtils.isNULLStr(deviceSns)) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("the deviceSns is empty!");
            return false;
        }
        if (StringUtils.isNULLStr(packageType)) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("the packageType is empty!");
            return false;
        }
        return CallbackPackageSnMappingUtils.doRecord2PersistFile(packageType, deviceSns, packageName);
    }

    private static String spliceDeviceSns(List<DevNode> devices) {
        if (null == devices || devices.isEmpty()) {
            return null;
        }
        JSONArray toJson = new JSONArray();
        for (DevNode dev : devices) {
            if (null == dev.getDeviceSerialNumber()) {
                ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("found device with no serial number!");
                return null;
            }
            JSONObject devInfo = new JSONObject();
            devInfo.put("SN", (Object)dev.getDeviceSerialNumber());
            devInfo.put("DeviceType", (Object)(null != dev.getItDeviceType() ? dev.getItDeviceType().getName() : "unknown"));
            toJson.put((Object)devInfo);
        }
        return toJson.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized boolean doRecord2PersistFile(String fileType, String deviceSNs, String packageName) {
        String uploadDir = CallbackPackageSnMappingUtils.getSmartKitUploadDir();
        if (StringUtils.isNULLStr(uploadDir)) {
            return false;
        }
        FileChannel channel = null;
        FileLock lock = null;
        RandomAccessFile raf = null;
        try {
            String destinationFile;
            File file;
            File uploadDirect = new File(uploadDir);
            if (!uploadDirect.exists()) {
                uploadDirect.mkdir();
            }
            if (!(file = new File(destinationFile = uploadDir + MAPPING_FILE_NAME_PREFIX + System.currentTimeMillis() + MAPPING_FILE_NAME_SUFFIX)).exists()) {
                file.createNewFile();
            }
            JSONObject jsObj = new JSONObject();
            jsObj.put("fileType", (Object)fileType);
            jsObj.put("devicesInfo", (Object)new JSONArray(deviceSNs));
            raf = new RandomAccessFile(destinationFile, "rw");
            raf.seek(raf.length());
            channel = raf.getChannel();
            lock = channel.lock();
            String toWrite = packageName + "=" + jsObj.toString() + "\r\n";
            ByteBuffer sendBuffer = ByteBuffer.wrap(toWrite.getBytes(Charset.defaultCharset()));
            channel.write(sendBuffer);
            boolean bl = true;
            CallbackPackageSnMappingUtils.dealResourceReleasing(channel, lock, raf);
            return bl;
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("file {} not found!", (Object)MAPPING_FILE_NAME_SUFFIX);
            boolean bl = false;
            return bl;
        }
        catch (IOException e2) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("IOException on doRecord2PersistFile!" + e2);
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            CallbackPackageSnMappingUtils.dealResourceReleasing(channel, lock, raf);
        }
    }

    private static void dealResourceReleasing(FileChannel channel, FileLock lock, RandomAccessFile raf) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("IOException on release lock!" + e);
            }
        }
        if (null != raf) {
            try {
                raf.close();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("IOException on release raf!" + e);
            }
        }
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("IOException on release channel!" + e);
            }
        }
    }

    public static String getSmartKitUploadDir() {
        try {
            String toolboxPath = UserOpDataSaveUtil.getToolBoxPath();
            String uploadFileDir = toolboxPath + UPLOAD_PATH + File.separator;
            UserOpDataSaveUtil.checkAndMakeFile(new File(toolboxPath), true);
            return uploadFileDir;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(CallbackPackageSnMappingUtils.class).error("exception on getToolBoxPath!" + e);
            return null;
        }
    }
}

